/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.ExternalPhrase;
import com.avaya.sce.runtime.Phrase;
import com.avaya.sce.runtime.PhraseVariableElement;
import com.avaya.sce.runtimecommon.ICollection;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.VariableName;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;

public final class DTMFTonePhraseVariableElement
extends PhraseVariableElement {
    private static final Phrase[] EMPTY_PHRASE_ARRAY = new Phrase[0];
    private static final String[] DTMF_FILE_NAMES = new String[]{"S", "P", "sil100", "sil500", "sil1000"};
    private static final String DTMF_AUDIO_URLFRAG = "/data/dtmf/%s.wav";

    private static String getToneFileName(char c) {
        if (c >= '0' && c <= '9') {
            return Character.toString(c);
        }
        switch (c) {
            case '*': {
                return DTMF_FILE_NAMES[0];
            }
            case '#': {
                return DTMF_FILE_NAMES[1];
            }
            case ',': {
                return DTMF_FILE_NAMES[2];
            }
            case ' ': {
                return DTMF_FILE_NAMES[3];
            }
            case '.': {
                return DTMF_FILE_NAMES[4];
            }
        }
        c = Character.toUpperCase(c);
        if (c >= 'A' && c <= 'D') {
            return Character.toString(c);
        }
        return null;
    }

    public DTMFTonePhraseVariableElement(String variableName) {
        super(variableName, PhraseVariableElement.Type.DTMF_TONES);
    }

    public DTMFTonePhraseVariableElement(String variableName, boolean asMedia) {
        super(variableName, PhraseVariableElement.Type.DTMF_TONES, asMedia);
    }

    @Override
    public final Phrase getPhrase() {
        throw new UnsupportedOperationException("DTMF Tone phrase variables does not support this method.");
    }

    @Override
    public final Phrase[] getPhrases() {
        ArrayList<Phrase> phList = new ArrayList<Phrase>(50);
        IVariable variable = this.mySession.getVariable(new VariableName(this.getValue()).getVarName());
        if (variable == null) {
            throw new SCERuntimeException("Unable to get session variable: " + this.getValue());
        }
        if (variable.isCollection()) {
            ICollection phraseCollection = variable.getCollection();
            phraseCollection.reset();
            while (phraseCollection.hasMore()) {
                phraseCollection.next();
                this.addDTMFPhrases(phList);
            }
        } else {
            this.addDTMFPhrases(phList);
        }
        return phList.toArray(EMPTY_PHRASE_ARRAY);
    }

    private void addDTMFPhrases(List<Phrase> phList) {
        IVariableField field = this.mySession.getVariableField(new VariableName(this.getValue()));
        if (field == null) {
            throw new SCERuntimeException("Unable to get session variable: " + this.getValue());
        }
        String dtmfStr = field.getStringValue();
        if (this.mySession.isDDTraceEnabled()) {
            this.mySession.getTraceOutput().writeln(1, "Converting variable [" + this.getValue() + "] value [" + dtmfStr + "] to DTMF tones.");
        }
        StringCharacterIterator iter = new StringCharacterIterator(dtmfStr);
        char c = iter.first();
        while (c != '\uffff') {
            Phrase p = this.createDTMFPhrase(c);
            if (p != null) {
                phList.add(p);
            }
            c = iter.next();
        }
    }

    private Phrase createDTMFPhrase(char c) {
        String name = DTMFTonePhraseVariableElement.getToneFileName(c);
        if (name == null) {
            if (this.mySession.isDDTraceEnabled()) {
                this.mySession.getTraceOutput().writeln(3, "Invalid DTMF value: [" + c + "].  Skipping.");
            }
            return null;
        }
        URL url = this.mySession.getFileURL(String.format(DTMF_AUDIO_URLFRAG, name));
        return new ExternalPhrase(url.toString());
    }
}

