/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.ade.common.utils.io.IO;
import com.avaya.ade.common.utils.xml.XML;

public class GrammarItem {
    public static final String REPEAT_NONE = "-1";
    public static final String REPEAT_PROBABILITY_NONE = "-1";
    public static final String WEIGHT_NONE = "-1";
    public static final String TAG_NONE = "";
    String value;
    String tag;
    String repeat;
    String repeatProbability;
    String weight;
    String compatibility = "SRGS-Literals";
    String mode = "voice";

    private String cleanValue(String text) {
        try {
            if (!this.mode.equalsIgnoreCase("text")) {
                text = IO.sanitizeString((String)text.toLowerCase(), (String)"-");
                text = text.replace('-', ' ');
            } else {
                text = IO.removeHTMLFromString((String)text.toLowerCase());
                text = XML.xmlEscapeString((String)text);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        text = text.trim();
        return text;
    }

    public GrammarItem(String value, String tag, String repeat, String repeatProbability, String weight) throws IllegalArgumentException {
        this.validateRepeat(repeat);
        this.validateRepeatProb(repeatProbability);
        this.validateWeight(weight);
        this.validateTag(tag);
        this.value = value;
        this.tag = tag;
        this.repeat = repeat;
        this.repeatProbability = repeatProbability;
        this.weight = weight;
    }

    public GrammarItem(String value, String tag) throws IllegalArgumentException {
        this.validateTag(tag);
        this.value = value;
        this.tag = tag;
        this.repeat = "-1";
        this.repeatProbability = "-1";
        this.weight = "-1";
    }

    public GrammarItem(String value) throws IllegalArgumentException {
        this.value = value;
        this.tag = value;
        this.repeat = "-1";
        this.repeatProbability = "-1";
        this.weight = "-1";
    }

    private void validateTag(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Tag invalid, tag must not be null use GrammarItem.TAG_NONE");
        }
    }

    private void validateWeight(String value) throws IllegalArgumentException {
        if (!this.doValidateWeight(value)) {
            throw new IllegalArgumentException("Weight invalid, allowable values are:  n, n >=0 or -1 (n/a)");
        }
    }

    private boolean doValidateWeight(String value) {
        if (value.equals("-1")) {
            return true;
        }
        try {
            int weight = Integer.parseInt(value);
            return weight >= 0;
        }
        catch (Exception e1) {
            try {
                float weight = Float.parseFloat(value);
                return (double)weight >= 0.0;
            }
            catch (Exception e2) {
                return false;
            }
        }
    }

    private void validateRepeatProb(String value) throws IllegalArgumentException {
        if (!this.doValidateRepeatProb(value)) {
            throw new IllegalArgumentException("Repeat probability invalid, allowable values are: n where  n >= 0.0  and n <= 1.0 or -1 (n/a)");
        }
    }

    private boolean doValidateRepeatProb(String value) {
        if (value.equals("-1")) {
            return true;
        }
        try {
            float f = Float.parseFloat(value);
            if ((double)f >= 0.0 && (double)f <= 1.0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void validateRepeat(String value) throws IllegalArgumentException {
        if (!this.doValidateRepeat(value)) {
            throw new IllegalArgumentException("Weight invalid, allowable values are:  n, n >=0 or -1 (n/a)");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doValidateRepeat(String value) {
        if (value.equals("-1")) {
            return true;
        }
        int index = value.indexOf(45);
        if (index == -1) {
            try {
                int m = Integer.parseInt(value);
                return m >= 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (index == value.length() - 1) {
            String numStr = value.substring(0, index);
            try {
                int rep = Integer.parseInt(numStr);
                return rep >= 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        String numStr = value.substring(0, index);
        int m = Integer.parseInt(numStr);
        if (m < 0) return false;
        numStr = value.substring(index + 1);
        try {
            int n = Integer.parseInt(numStr);
            if (n == 0) return false;
            return n > m;
        }
        catch (Exception e) {
            try {
                return false;
            }
            catch (Exception e2) {
                return false;
            }
        }
    }

    private void genAttr(StringBuffer sb, String attr, String value) {
        if (value != null) {
            sb.append(" ");
            sb.append(attr);
            sb.append("=\"");
            sb.append(value);
            sb.append("\"");
        }
    }

    String toString(int i) {
        this.value = this.cleanValue(this.value);
        StringBuffer sb = new StringBuffer();
        if (this.value.length() == 0) {
            return TAG_NONE;
        }
        sb.append("<item");
        if (!this.repeat.equals("-1")) {
            this.genAttr(sb, "repeat", this.repeat);
        }
        if (!this.weight.equals("-1")) {
            this.genAttr(sb, "weight", this.weight);
        }
        if (!this.repeatProbability.equals("-1")) {
            this.genAttr(sb, "repeat-prob", this.repeatProbability);
        }
        sb.append(">");
        sb.append(this.value);
        if (this.compatibility.equals("Nuance OSR")) {
            if (!this.tag.equals(TAG_NONE)) {
                sb.append("<tag>atag+='" + this.tag + "'" + "</tag>");
            } else {
                sb.append("<tag>atag+='" + this.value + "'" + "</tag>");
            }
        }
        if (this.compatibility.equals("SRGS-SISR")) {
            if (!this.tag.equals(TAG_NONE)) {
                sb.append("<tag>out+=\"" + this.tag + "\";" + "</tag>");
            } else {
                sb.append("<tag>out+=\"" + this.value + "\";" + "</tag>");
            }
        }
        if (this.compatibility.equals("IBM")) {
            if (!this.tag.equals(TAG_NONE)) {
                sb.append("<tag>$+=\"" + this.tag + "\";</tag>");
            } else {
                sb.append("<tag>$+=\"" + this.value + "\";</tag>");
            }
        }
        if (this.compatibility.equals("SRGS-Literals")) {
            if (!this.tag.equals(TAG_NONE)) {
                sb.append("<tag>" + this.tag + "</tag>");
            } else {
                sb.append("<tag>" + this.value + "</tag>");
            }
        }
        sb.append("</item>");
        return sb.toString();
    }

    public void setCompatibility(String compatibility) {
        this.compatibility = compatibility;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

