/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.DynamicGrammar;
import com.avaya.sce.runtime.Grammar;
import com.avaya.sce.runtime.GrammarInfo;
import com.avaya.sce.runtime.ILanguage;
import com.avaya.sce.runtime.IOutputGenerator;
import com.avaya.sce.runtime.IRuntimeGrammar;
import com.avaya.sce.runtime.IRuntimePrompt;
import com.avaya.sce.runtime.Prompt;
import com.avaya.sce.runtime.PromptRefInfo;
import com.avaya.sce.runtime.internal.ASRTTSFinder;
import com.avaya.sce.runtime.internal.GrammarFinder;
import com.avaya.sce.runtime.internal.PromptFinder;
import com.avaya.sce.runtime.perf.Performance;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.SCESession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;

public class InputCommon {
    protected String name;
    protected ArrayList<IRuntimeGrammar> grammars = new ArrayList();
    protected Collection grammarInfos;
    protected Collection promptNames;
    protected ArrayList<IRuntimePrompt> prompts = new ArrayList();
    protected LinkedHashMap<String, String> uniqueColumns = new LinkedHashMap();

    public InputCommon(String name, Collection grammarInfos, Collection promptNames) {
        this.name = name;
        this.grammarInfos = grammarInfos;
        this.promptNames = promptNames;
    }

    public void loadPrompts(SCESession mySession) {
        if (this.promptNames != null) {
            for (Object promptInfo : this.promptNames) {
                String promptName = "";
                String language = "";
                if (promptInfo instanceof String) {
                    promptName = (String)promptInfo;
                } else {
                    promptName = ((PromptRefInfo)promptInfo).getName();
                    language = ((PromptRefInfo)promptInfo).getLanguage();
                }
                IRuntimePrompt prompt = PromptFinder.load(promptName, language, mySession);
                this.prompts.add(prompt);
                long start = System.currentTimeMillis();
                prompt.updatePrompt(mySession);
                long stop = System.currentTimeMillis();
                Performance.update("_avaya-update-prompt|Update Prompt", stop - start, mySession.getServlet().getServletName());
                Prompt p = (Prompt)prompt;
                p.setFormPrompt(false);
            }
        }
    }

    public void loadGrammarsA(SCESession mySession) {
        if (this.grammarInfos != null) {
            for (GrammarInfo grammarInfo : this.grammarInfos) {
                String tempLang;
                String language = grammarInfo.getLanguage();
                String string = tempLang = language.equals("") ? mySession.getCurrentLanguage() : language;
                IRuntimeGrammar grammar = GrammarFinder.load(grammarInfo.getName(), tempLang);
                if (grammar == null) continue;
                grammar.setWeight(grammarInfo.getWeight());
                if (language.length() > 0) {
                    if (grammar instanceof DynamicGrammar) {
                        String langCode = this.getLangClass(language).getASRLanguage();
                        ((DynamicGrammar)grammar).setLanguage(langCode);
                    } else if (grammar instanceof Grammar) {
                        ((Grammar)grammar).setLanguageLabel(language);
                    }
                }
                grammar.setSession(mySession);
                long start = System.currentTimeMillis();
                grammar.updateGrammar(mySession);
                long stop = System.currentTimeMillis();
                Performance.update("_avaya-update-grammar|Update Grammar", stop - start, mySession.getServlet().getServletName());
                this.grammars.add(grammar);
            }
        }
    }

    public void loadGrammarsB(SCESession mySession) {
        for (IRuntimeGrammar grammar : this.grammars) {
            if (!grammar.isEnabled()) continue;
            if (grammar instanceof DynamicGrammar) {
                DynamicGrammar dg = (DynamicGrammar)grammar;
                dg.buildGrammar(mySession);
                dg.setcColIds();
            }
            for (String colName : grammar.getColumnIds()) {
                this.uniqueColumns.put(colName, colName);
            }
        }
    }

    public void loadGrammars(SCESession mySession) {
        this.loadGrammarsA(mySession);
        this.loadGrammarsB(mySession);
    }

    protected void updateGrammarSlots(ArrayList<IRuntimeGrammar> grammars) {
        this.uniqueColumns.clear();
        for (IRuntimeGrammar grammar : grammars) {
            if (!grammar.isEnabled()) continue;
            for (String colName : grammar.getColumnIds()) {
                this.uniqueColumns.put(colName, colName);
            }
        }
    }

    public Collection<String> getUniqueColNames() {
        return this.uniqueColumns.values();
    }

    public void genPrompts(IOutputGenerator generator) {
        for (int i = 0; i < this.prompts.size(); ++i) {
            Prompt prompt = (Prompt)this.prompts.get(i);
            prompt.generate(generator);
        }
    }

    public void genGrammars(IOutputGenerator generator) {
        for (int i = 0; i < this.grammars.size(); ++i) {
            IRuntimeGrammar grammar = this.grammars.get(i);
            if (!grammar.isEnabled()) continue;
            grammar.generate(generator);
        }
    }

    public void cleanup() {
        if (this.grammars != null) {
            this.grammars.clear();
            this.grammars = null;
        }
        if (this.grammarInfos != null) {
            this.grammarInfos.clear();
            this.grammarInfos = null;
        }
        if (this.promptNames != null) {
            this.promptNames.clear();
            this.promptNames = null;
        }
        if (this.prompts != null) {
            this.prompts.clear();
            this.prompts = null;
        }
    }

    public Collection<IRuntimeGrammar> getGrammars() {
        return this.grammars;
    }

    public Collection<IRuntimePrompt> getPrompts() {
        return this.prompts;
    }

    public String getName() {
        return this.name;
    }

    private ILanguage getLangClass(String language) {
        ILanguage langClass = null;
        try {
            langClass = (ILanguage)ASRTTSFinder.getASRTTSFinder(language).getInstance("ASR_TTS_Language");
        }
        catch (Exception e) {
            throw new SCERuntimeException("Language [" + language + "] does not exits", e);
        }
        return langClass;
    }
}

