/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.ade.common.utils.crypto.Base64Encoder;
import com.avaya.ade.common.utils.io.IO;
import com.avaya.runtime.platforms.Toolkit;
import com.avaya.sce.runtime.Format;
import com.avaya.sce.runtime.ILocaleFormatter;
import com.avaya.sce.runtime.InputFormatException;
import com.avaya.sce.runtime.LocaleResults;
import com.avaya.sce.runtime.Phrase;
import com.avaya.sce.runtime.Phraseset;
import com.avaya.sce.runtime.RenderHint;
import com.avaya.sce.runtime.Textset;
import com.avaya.sce.runtime.internal.PhraseFinder;
import com.avaya.sce.runtime.internal.PhrasesetFinder;
import com.avaya.sce.runtime.internal.TextsetFinder;
import com.avaya.sce.runtime.tracking.ReportInfo;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class PromptElement {
    public static final int TEXT = 1;
    public static final int PHRASE = 2;
    public static final int VARIABLE_TEXT = 3;
    public static final int VARIABLE_AUDIO = 4;
    public static final int XML_TAG_BEGIN = 5;
    public static final int XML_TAG_END = 6;
    public static final int XML_TAG_FULL = 7;
    public static final int EXPRESSION = 8;
    public static final int PHRASESET = 9;
    public static final int VARIABLE_PHRASE = 10;
    public static final int MEDIA = 11;
    public static final int CONSTANT_AUDIO = 12;
    public static final int EMAIL = 13;
    public static final int SMS = 14;
    public static final int EMAILTEXT = 15;
    public static final int SMSTEXT = 16;
    public static final int WEBELEMENT = 17;
    public static final int HTMLTEXTELEMENT = 18;
    public static final int WEB_LOOP_VAR_COLL = 19;
    private int type;
    private boolean enabled;
    private boolean noCache = false;
    protected SCESession mySession;
    private String value;
    private Format formats;
    private RenderHint hint;
    private boolean isWaveFile;
    private boolean asMedia;
    private String language;
    private String textsetLabel;
    private String webElemType;
    private int width;
    private int height;
    private String controls;

    public PromptElement(int type, String value) {
        this(type, value, null, null, false);
    }

    public PromptElement(int type, String value, String webElemType, String textsetLabel) {
        this.type = type;
        this.value = value;
        this.webElemType = webElemType;
        this.textsetLabel = textsetLabel;
    }

    public PromptElement(int type, String value, String webElemType, String textsetLabel, int width, int height) {
        this(type, value, webElemType, textsetLabel);
        this.width = width;
        this.height = height;
    }

    public PromptElement(int type, String value, String webElemType, String textsetLabel, int width, int height, String controls) {
        this(type, value, webElemType, textsetLabel, width, height);
        this.controls = controls;
    }

    public PromptElement(int type, String value, boolean asMedia) {
        this(type, value, null, null, asMedia);
    }

    public PromptElement(int type, String value, boolean asMedia, boolean noCache) {
        this(type, value, null, null, asMedia);
        this.noCache = noCache;
    }

    public PromptElement(int type, String value, Format formats) {
        this(type, value, formats, null, false);
    }

    public PromptElement(int type, String value, Format formats, boolean asMedia) {
        this(type, value, formats, null, asMedia);
    }

    public PromptElement(int type, String value, Format formats, RenderHint hint) {
        this.type = type;
        this.value = value;
        this.formats = formats;
        this.hint = hint;
        this.enabled = true;
        this.isWaveFile = false;
        this.asMedia = false;
    }

    public PromptElement(int type, String value, Format formats, RenderHint hint, boolean asMedia) {
        this.type = type;
        this.value = value;
        this.formats = formats;
        this.hint = hint;
        this.enabled = true;
        this.isWaveFile = false;
        this.asMedia = asMedia;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getType() {
        return this.type;
    }

    public void setSession(SCESession mySession) {
        this.mySession = mySession;
    }

    public Phrase getPhrase() {
        Phrase phrase = null;
        if (this.language == null) {
            this.language = this.mySession.getCurrentLanguage();
        }
        if (this.type == 2) {
            phrase = PhraseFinder.load(this.value, this.language);
        }
        if (this.type == 9) {
            StringTokenizer st = new StringTokenizer(this.value, ":");
            Phraseset phraseset = PhrasesetFinder.load(st.nextToken(), this.language);
            phraseset.setMySession(this.mySession);
            phrase = phraseset.getPhrase(st.nextToken());
        }
        if (phrase != null) {
            if (phrase.mySession != null && phrase.mySession != this.mySession) {
                throw new IllegalStateException("Sanity check failure--sessions do not match!");
            }
            phrase.mySession = this.mySession;
        } else {
            this.mySession.throwRTException("Could not find phrase : " + this.value + " in language " + this.language);
        }
        phrase.setNoCache(this.getNoCache());
        return phrase;
    }

    public String getText() {
        switch (this.type) {
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                return this.value;
            }
        }
        return null;
    }

    private static boolean checkExt(String fileName, String ext) {
        int index = fileName.lastIndexOf(46);
        if (index != -1) {
            String fileExt = fileName.substring(index + 1);
            return fileExt.equals(ext);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getFormattedVariableText() {
        String varValue;
        Boolean isPrivate;
        if (this.type != 3) return null;
        VariableName varName = new VariableName(this.value);
        IVariableField var = this.mySession.getVariableField(varName);
        if (var == null) {
            this.mySession.throwRTException("Variable " + this.value + " does not exist");
        }
        if ((isPrivate = (Boolean)var.getAttribute("avaya.dd.private")).booleanValue()) {
            this.mySession.setProperty("___sagenovxmltrace", (Object)new Boolean(true));
        }
        if ((varValue = var.getStringValue()) == null) {
            varValue = "";
        }
        if (varValue.equals("__DD_NULL")) {
            varValue = "";
        }
        if (this.formats == null) return varValue;
        String fmt = this.formats.get("format");
        if (fmt.equals("filename")) {
            if (PromptElement.checkExt(varValue, "txt")) {
                this.isWaveFile = false;
                BufferedReader reader = null;
                InputStreamReader fr = null;
                try {
                    StringBuffer buf = new StringBuffer();
                    String str = null;
                    varValue = this.mySession.getAbsoluteTempFilePath(varValue);
                    fr = new FileReader(varValue);
                    reader = new BufferedReader(fr, 65536);
                    do {
                        if ((str = reader.readLine()) == null) continue;
                        buf.append(str);
                    } while (str != null);
                    varValue = buf.toString();
                    return varValue;
                }
                catch (Exception e) {
                    ReportInfo.alarm("Warning", "Error reading message file :" + varValue, e, this.mySession);
                    this.mySession.throwRTException("Error reading message file :" + varValue, e);
                    return varValue;
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Exception e2) {}
                    try {
                        if (fr != null) {
                            fr.close();
                        }
                    }
                    catch (Exception e2) {}
                }
            }
            this.isWaveFile = true;
            return this.mySession.getTempFileURL(varValue).toString();
        }
        if (fmt.equals("digits")) {
            StringBuffer buf = new StringBuffer(varValue.length() * 2);
            int i = 0;
            while (i < varValue.length()) {
                buf.append(varValue.charAt(i));
                buf.append(' ');
                ++i;
            }
            return buf.toString();
        }
        if (fmt.equals("text")) {
            return varValue;
        }
        if (!fmt.equals("fileurl")) return null;
        if (PromptElement.checkExt(varValue, "txt")) {
            this.isWaveFile = false;
            try {
                StringBuffer buf = new StringBuffer();
                String str = null;
                URL fileUrl = new URL(varValue);
                BufferedReader reader = new BufferedReader(new InputStreamReader(fileUrl.openStream()), 65536);
                do {
                    if ((str = reader.readLine()) == null) continue;
                    buf.append(str);
                } while (str != null);
                reader.close();
                return buf.toString();
            }
            catch (Exception e) {
                ReportInfo.alarm("Warning", "Error reading message file :" + varValue, e, this.mySession);
            }
            return varValue;
        }
        this.isWaveFile = true;
        return varValue;
    }

    public Phrase[] getFormattedVariableAudio() {
        if (this.type == 4 || this.type == 12) {
            String varValue = null;
            if (this.type == 4) {
                Boolean isPrivate;
                VariableName varName = new VariableName(this.value);
                IVariableField var = this.mySession.getVariableField(varName);
                if (var == null) {
                    this.mySession.throwRTException("Variable " + this.value + " does not exist");
                }
                if ((isPrivate = (Boolean)var.getAttribute("avaya.dd.private")).booleanValue()) {
                    this.mySession.setProperty("___sagenovxmltrace", (Object)new Boolean(true));
                }
                if ((varValue = var.getStringValue()) == null) {
                    varValue = "";
                }
                if (varValue.equals("__DD_NULL")) {
                    varValue = "";
                }
            } else {
                varValue = this.value;
            }
            ILocaleFormatter formatter = Toolkit.getFormatter(this.mySession);
            if (this.language != null) {
                formatter = Toolkit.getFormatterByLanguage(this.language);
            }
            if (formatter == null) {
                this.mySession.throwRTException("Unable to format variable data to audio clips because localization bundle for language \"" + Toolkit.getCurrentLanguageLocalization(this.mySession) + "\" has not been installed for this project.");
            }
            String[] values = null;
            try {
                LocaleResults message = new LocaleResults();
                values = formatter.formatTextToAudio(varValue, this.formats, message);
                if (message.getMessages().size() > 0) {
                    for (int i = 0; i < message.getMessages().size(); ++i) {
                        ReportInfo.alarm("Warning", "Problem formatting variable : " + this.value.toString() + " : " + message.getMessages().get(i), this.mySession);
                    }
                }
            }
            catch (InputFormatException e) {
                ReportInfo.alarm("Warning", "Error formatting variable : " + this.value.toString() + " : " + e, this.mySession);
            }
            if (values == null) {
                values = new String[]{};
            }
            ArrayList<Phrase> list = new ArrayList<Phrase>(values.length);
            String phraseSetName = "std_" + Toolkit.getCurrentLanguageLocalization(this.mySession).replace('-', '_');
            Phraseset set = null;
            if (this.language == null) {
                this.language = this.mySession.getCurrentLanguage();
            } else {
                phraseSetName = "std_" + Toolkit.getLanguageLocalization(this.language).replace('-', '_');
            }
            try {
                set = PhrasesetFinder.load(phraseSetName, this.language);
                set.setMySession(this.mySession);
            }
            catch (Exception e) {
                // empty catch block
            }
            for (int i = 0; i < values.length; ++i) {
                Phrase phrase = set != null ? set.getPhrase(values[i]) : PhraseFinder.load(values[i], this.language);
                list.add(phrase);
            }
            return list.toArray(new Phrase[0]);
        }
        return new Phrase[0];
    }

    public Format getFormats() {
        return this.formats;
    }

    public RenderHint getRenderHint() {
        return this.hint;
    }

    public boolean isWaveFile() {
        return this.isWaveFile;
    }

    public RenderHint getHint() {
        return this.hint;
    }

    public void setHint(RenderHint hint) {
        this.hint = hint;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setFormats(Format formats) {
        this.formats = formats;
    }

    public void setWaveFile(boolean isWaveFile) {
        this.isWaveFile = isWaveFile;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setAsMedia(boolean asMedia) {
        this.asMedia = asMedia;
    }

    public boolean getAsMedia() {
        return this.asMedia;
    }

    public boolean getNoCache() {
        return this.noCache;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLabel() {
        if (this.textsetLabel.isEmpty() || this.mySession == null) {
            return "";
        }
        String language = this.mySession.getCurrentLanguage();
        StringTokenizer st = new StringTokenizer(this.textsetLabel, ":");
        Textset tset = TextsetFinder.load(st.nextToken(), language);
        tset.setMySession(this.mySession);
        String nextChoice = tset.getTextsetText(st.nextToken()).getText();
        return nextChoice;
    }

    public String getWebElemType() {
        return this.webElemType;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getAVControls() {
        return this.controls;
    }

    public String getFileURLValue() {
        IVariableField field = this.mySession.getVariableField(new VariableName(this.getValue()));
        String value = field.getStringValue();
        if (value.indexOf("http") != 0 && value.indexOf("data") != 0 && value.indexOf("blob") != 0) {
            if (value.indexOf("file") == 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("data:image/png;base64,");
                try {
                    byte[] fileBytes = IO.readFileBytes((File)new File(new URI(value)));
                    sb.append(Base64Encoder.encode((byte[])fileBytes));
                }
                catch (Exception e) {
                    this.mySession.getTraceOutput().writeln(4, "Problem read file - " + value + "(" + e + ")");
                }
                return sb.toString();
            }
            String fileName = value.substring(value.lastIndexOf(File.separator) + 1);
            URL url = this.mySession.getFileURL("/data/temp/" + fileName);
            return url.toString();
        }
        return value;
    }
}

