/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.Form;
import com.avaya.sce.runtime.Handler;
import com.avaya.sce.runtime.IGenerator;
import com.avaya.sce.runtime.IOutputGenerator;
import com.avaya.sce.runtime.IRuntimeGrammar;
import com.avaya.sce.runtime.InputCommon;
import com.avaya.sce.runtime.Prompt;
import com.avaya.sce.runtime.Submit;
import com.avaya.sce.runtime.internal.PromptFinder;
import com.avaya.sce.runtime.perf.Performance;
import com.avaya.sce.runtime.varoperations.PrepareAAI;
import java.util.Collection;

public class Transfer
extends InputCommon
implements IGenerator {
    public static final int CONSTANT = 1;
    public static final int VARIABLE = 2;
    String destNumber;
    int destType;
    String transferAudio;
    String connectTimeout;
    String maxTime;
    TransferType transferType;
    Form form;
    Prompt xferAudio;
    String aai;
    int aaiType;
    boolean convertEventsToErrors = false;
    boolean hexEncodeAAI = false;
    int timeoutType = 1;
    boolean transferToAACC;
    Mode mode;
    Protocol protocol;
    String ucidVar;

    public Transfer(String name, String destNumber, int destType, String transferAudio, String connectTimeout, int timeoutType, String maxTime, TransferType type, Collection promptNames, Collection grammarInfos, Form form, String aai, int aaiType, boolean convertEventsToErrors, boolean hexEncodeAAI) {
        super(name, grammarInfos, promptNames);
        this.destNumber = destNumber;
        this.destType = destType;
        this.transferAudio = transferAudio;
        this.connectTimeout = connectTimeout;
        this.timeoutType = timeoutType;
        this.maxTime = maxTime;
        this.transferType = type;
        this.form = form;
        this.aai = aai;
        this.aaiType = aaiType;
        this.convertEventsToErrors = convertEventsToErrors;
        this.hexEncodeAAI = hexEncodeAAI;
    }

    public Transfer(String name, String destNumber, int destType, String transferAudio, String connectTimeout, int timeoutType, String maxTime, TransferType type, Collection promptNames, Collection grammarInfos, Form form, String aai, int aaiType, boolean convertEventsToErrors, boolean transferToAACC, Mode mode, Protocol protocol, String ucidVar) {
        this(name, destNumber, destType, transferAudio, connectTimeout, timeoutType, maxTime, type, promptNames, grammarInfos, form, aai, aaiType, convertEventsToErrors, false);
        this.transferToAACC = transferToAACC;
        this.mode = mode;
        this.protocol = protocol;
        this.ucidVar = ucidVar;
    }

    @Deprecated
    public Transfer(String name, String destNumber, int destType, String transferAudio, String connectTimeout, String maxTime, TransferType type, Collection promptNames, Collection grammarInfos, Form form, String aai, int aaiType, boolean convertEventsToErrors) {
        this(name, destNumber, destType, transferAudio, connectTimeout, 1, maxTime, type, promptNames, grammarInfos, form, aai, aaiType, convertEventsToErrors, false);
    }

    @Deprecated
    public Transfer(String name, String destNumber, int destType, String transferAudio, String connectTimeout, String maxTime, TransferType type, Collection promptNames, Collection grammarInfos, Form form, String aai, int aaiType) {
        this(name, destNumber, destType, transferAudio, connectTimeout, 1, maxTime, type, promptNames, grammarInfos, form, aai, aaiType, false, false);
    }

    @Deprecated
    public Transfer(String name, String destNumber, int destType, String transferAudio, String connectTimeout, String maxTime, boolean bridged, Collection promptNames, Collection grammarInfos, Form form, String aai, int aaiType) {
        this(name, destNumber, destType, transferAudio, connectTimeout, maxTime, bridged ? TransferType.BRIDGED : TransferType.BLIND, promptNames, grammarInfos, form, aai, aaiType);
    }

    @Override
    public void generate(IOutputGenerator generator) {
        this.loadPrompts(generator.getMySession());
        this.loadGrammars(generator.getMySession());
        if (this.transferAudio != null) {
            this.xferAudio = (Prompt)PromptFinder.load(this.transferAudio, generator.getMySession().getCurrentLanguage(), generator.getMySession());
            long start = System.currentTimeMillis();
            this.xferAudio.updatePrompt(generator.getMySession());
            long stop = System.currentTimeMillis();
            Performance.update("_avaya-update-prompt|Update Prompt", stop - start, generator.getMySession().getServlet().getServletName());
        }
        generator.transferBegin(this, this.prompts);
        this.genPrompts(generator);
        this.genGrammars(generator);
        Handler handler = new Handler(null, true, "connection.disconnect.transfer", "_event");
        if (this.convertEventsToErrors()) {
            handler.addType("error");
        }
        handler.setSubmitObject((Submit)generator.getMySession().getProperty("dd.form.completedsubmit"));
        handler.setTransfer(this);
        handler.generate(generator);
        generator.transferEnd(this);
    }

    @Deprecated
    public boolean isBridged() {
        return this.getTransferType() == TransferType.BRIDGED;
    }

    public String getConnectTimeout() {
        return this.connectTimeout;
    }

    public String getDestNumber() {
        return this.destNumber;
    }

    public String getTransferAudio() {
        return this.transferAudio;
    }

    public int getDestType() {
        return this.destType;
    }

    public Prompt getXferAudio() {
        return this.xferAudio;
    }

    public String getMaxTime() {
        return this.maxTime;
    }

    public void setTransferAudio(String string) {
        this.transferAudio = string;
    }

    @Override
    public Collection<IRuntimeGrammar> getGrammars() {
        return this.grammars;
    }

    public String getAai() {
        return this.aai;
    }

    public int getAaiType() {
        return this.aaiType;
    }

    public Form getForm() {
        return this.form;
    }

    public void setForm(Form form) {
        this.form = form;
    }

    public void setAai(String aai) {
        this.aai = aai;
    }

    public void setAaiType(int aaiType) {
        this.aaiType = aaiType;
    }

    public void setConnectTimeout(String connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setDestNumber(String destNumber) {
        this.destNumber = destNumber;
    }

    public void setDestType(int destType) {
        this.destType = destType;
    }

    public void setMaxTime(String maxTime) {
        this.maxTime = maxTime;
    }

    public void setXferAudio(Prompt xferAudio) {
        this.xferAudio = xferAudio;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public boolean convertEventsToErrors() {
        return this.convertEventsToErrors;
    }

    public String checkHexEncodeAAI(String aaiStr) {
        if (this.hexEncodeAAI) {
            StringBuffer result = new StringBuffer();
            result.append("04C8");
            result.append(Integer.toString(2 * aaiStr.length(), 16));
            for (int i = 0; i < aaiStr.length(); ++i) {
                char x = aaiStr.charAt(i);
                result.append(Integer.toString(x, 16).toUpperCase());
            }
            result.append(";encoding=hex");
            return result.toString();
        }
        return aaiStr;
    }

    public String checkHexEncodeAAIForAACC(String aaiStr, String ucidStr) {
        String resultStr = aaiStr;
        if (this.transferToAACC) {
            if (this.mode == Mode.SHARED_UUI) {
                resultStr = aaiStr.length() == 0 ? "PD,00" : "PD,00;C8," + this.stringToHex(aaiStr);
                if (ucidStr.length() > 0) {
                    resultStr = resultStr + ";FA," + PrepareAAI.endcodeUcid(ucidStr);
                }
            } else if (aaiStr.length() > 0) {
                resultStr = "04" + this.stringToHex(aaiStr);
            }
        }
        return resultStr;
    }

    public final String stringToHex(String data) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < data.length(); ++i) {
            char x = data.charAt(i);
            result.append(Integer.toString(x, 16));
        }
        return result.toString();
    }

    public int getTimeoutType() {
        return this.timeoutType;
    }

    public void setTimeoutType(int timeoutType) {
        this.timeoutType = timeoutType;
    }

    public boolean isTransferToAACC() {
        return this.transferToAACC;
    }

    public void setTransferToAACC(boolean transferToAACC) {
        this.transferToAACC = transferToAACC;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setUcidVar(String ucidVar) {
        this.ucidVar = ucidVar;
    }

    public String getUcidVar() {
        return this.ucidVar;
    }

    public static enum Protocol {
        SIP,
        AML;

    }

    public static enum Mode {
        SHARED_UUI,
        SERVICE_PROVIDER;

    }

    public static enum TransferType {
        BLIND,
        BRIDGED,
        CONSULTATION;

    }
}

