/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.datetime;

import com.avaya.sce.runtimecommon.Debugging;
import com.avaya.sce.runtimecommon.IEvaluatable;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.VariableName;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ConvertDatetimeString
extends Debugging
implements IEvaluatable {
    private String srcVarName;
    private String constantStr;
    private String format;
    private String destVarName;

    public ConvertDatetimeString(String srcVarName, String constantStr, String format, String destVarName) {
        this.srcVarName = srcVarName;
        this.constantStr = constantStr;
        this.format = format;
        this.destVarName = destVarName;
    }

    public void evaluate(IRuntimeSession session) {
        if (session.isTraceEnabled()) {
            session.getTraceOutput().writeln(2, "Convert datetime string from [" + this.srcVarName + "] using format " + this.format);
        }
        IVariableField srcVar = null;
        IVariableField destVar = null;
        if (this.srcVarName != null) {
            srcVar = session.getVariableField(new VariableName(this.srcVarName));
        }
        destVar = session.getVariableField(new VariableName(this.destVarName));
        SimpleDateFormat sdf = new SimpleDateFormat(this.format);
        Date date = null;
        try {
            date = srcVar != null ? sdf.parse(srcVar.getStringValue()) : (this.constantStr == null || this.constantStr.length() == 0 ? new Date() : sdf.parse(this.constantStr));
        }
        catch (ParseException e) {
            session.getTraceOutput().writeln(4, "Error converting datetime string - " + e);
        }
        destVar.setValue((Object)date);
    }
}

