/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.datetime;

import com.avaya.runtime.platforms.Toolkit;
import com.avaya.sce.runtimecommon.Debugging;
import com.avaya.sce.runtimecommon.IEvaluatable;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class ConvertDatetimeVar
extends Debugging
implements IEvaluatable {
    private String destDateVarName;
    private String srcDateVarName;
    private String srcTimeName;

    public ConvertDatetimeVar(String srcDateVarName, String srcTimeName, String destDateVarName) {
        this.srcDateVarName = srcDateVarName;
        this.srcTimeName = srcTimeName;
        this.destDateVarName = destDateVarName;
    }

    public void evaluate(IRuntimeSession mySession) {
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(2, "Setting Datetime to [" + this.destDateVarName + "]");
        }
        IVariable dateVar = null;
        IVariable timeVar = null;
        if (this.srcDateVarName != null) {
            dateVar = mySession.getVariable(this.srcDateVarName);
        }
        if (this.srcTimeName != null) {
            timeVar = mySession.getVariable(this.srcTimeName);
        }
        String localString = Toolkit.getCurrentLanguageLocalization((SCESession)mySession);
        String[] langCountry = localString.split("-");
        Locale locale = new Locale(langCountry[0], langCountry[1]);
        Calendar calendar = Calendar.getInstance(locale);
        int day = calendar.get(5);
        int month = calendar.get(2) + 1;
        int year = calendar.get(1);
        if (dateVar != null) {
            year = this.getIntValue(dateVar.getComplexVariable().getField("year"));
            IVariableField monthField = dateVar.getComplexVariable().getField("monthinyear");
            if (monthField == null) {
                monthField = dateVar.getComplexVariable().getField("month");
            }
            month = this.getIntValue(monthField);
            IVariableField dayField = dateVar.getComplexVariable().getField("day");
            if (dayField == null) {
                dayField = dateVar.getComplexVariable().getField("dayofmonth");
            }
            day = this.getIntValue(dayField);
        }
        int hour = 0;
        int minute = 0;
        int second = 0;
        int millisec = 0;
        IVariableField timezone = null;
        if (timeVar != null) {
            hour = this.getIntValue(timeVar.getComplexVariable().getField("hour"));
            minute = this.getIntValue(timeVar.getComplexVariable().getField("minute"));
            second = this.getIntValue(timeVar.getComplexVariable().getField("second"));
            millisec = this.getIntValue(timeVar.getComplexVariable().getField("millisecond"));
            timezone = timeVar.getComplexVariable().getField("timezone");
        }
        String format = "yyyy/MM/dd kk:mm:ss.S";
        StringBuffer sb = new StringBuffer();
        sb.append(year).append("/").append(month).append("/").append(day);
        sb.append(" ");
        sb.append(hour).append(":").append(minute).append(":").append(second).append(".").append(millisec);
        if (timezone != null && timezone.getStringValue().length() > 0) {
            format = format + " Z";
            sb.append(" " + timezone.getStringValue());
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = sdf.parse(sb.toString());
        }
        catch (Exception e) {
            mySession.getTraceOutput().writeln(4, "Error parsing datetime input - " + sb + " using format " + format);
        }
        IVariableField field = mySession.getVariableField(new VariableName(this.destDateVarName));
        field.setValue((Object)date);
        DateFormat df = DateFormat.getInstance();
        String dateString = null;
        if (date != null) {
            dateString = df.format(date);
        }
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(2, "Datetime " + dateString + " got set.");
        }
    }

    private int getIntValue(IVariableField field) {
        if (field == null) {
            return 0;
        }
        String valueStr = field.getStringValue();
        int value = valueStr.equals("__DD_NULL") ? 0 : field.getIntValue();
        return value;
    }
}

