/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.internal;

import com.avaya.sce.runtime.SMS;
import com.avaya.sce.runtime.internal.ItemFinder;
import com.avaya.sce.runtime.internal.ResourceFinder;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.SCESession;

public class SMSFinder
extends ResourceFinder {
    public static final String TYPE = "SMS";

    public static SMSFinder getSMSFinder(String language) {
        return (SMSFinder)ItemFinder.getFinder(TYPE, language);
    }

    public static SMS load(String name, String language, SCESession mySession) {
        SMS sms = null;
        if (name != null) {
            try {
                sms = (SMS)SMSFinder.getSMSFinder(language).getInstance(name);
                sms.setSession(mySession);
            }
            catch (Exception e) {
                throw new SCERuntimeException("Error instantiating SMS", e);
            }
        }
        return sms;
    }

    public SMSFinder(String appLanguage) {
        super(appLanguage);
    }

    @Override
    protected String resolveName(String simpleName) {
        StringBuilder className = new StringBuilder(100);
        className.append(this.appLanguage);
        className.append(".");
        className.append("sms");
        className.append(".");
        className.append(simpleName);
        return className.toString();
    }

    @Override
    public String resolveResourceName(String simpleName) {
        StringBuilder itemName = new StringBuilder(100);
        itemName.append("/");
        itemName.append("data");
        itemName.append("/");
        itemName.append(this.appLanguage);
        itemName.append("/");
        itemName.append("sms");
        itemName.append("/");
        itemName.append(simpleName);
        return itemName.toString();
    }
}

