/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.internal;

import com.avaya.sce.runtime.Textset;
import com.avaya.sce.runtime.internal.ItemFinder;
import com.avaya.sce.runtime.internal.ResourceFinder;
import com.avaya.sce.runtimecommon.SCERuntimeException;

public class TextsetFinder
extends ResourceFinder {
    public static final String TYPE = "TEXTSET";

    public static TextsetFinder getTextsetFinder(String language) {
        return (TextsetFinder)ItemFinder.getFinder(TYPE, language);
    }

    public static Textset load(String name, String language) {
        Textset textset = null;
        if (name != null) {
            try {
                textset = (Textset)TextsetFinder.getTextsetFinder(language).getInstance(name);
                textset.setLanguage(language);
            }
            catch (Exception e) {
                throw new SCERuntimeException("Error instantiating textset", e);
            }
        }
        return textset;
    }

    public TextsetFinder(String appLanguage) {
        super(appLanguage);
    }

    @Override
    protected String resolveName(String simpleName) {
        StringBuilder className = new StringBuilder(100);
        className.append(this.appLanguage);
        className.append(".");
        className.append("textsets");
        className.append(".");
        className.append(simpleName);
        return className.toString();
    }

    @Override
    public String resolveResourceName(String simpleName) {
        return "";
    }
}

