/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.varoperations;

import com.avaya.sce.runtime.varoperations.AssignmentOperation;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.VariableName;

public class InsertString
extends AssignmentOperation {
    String destName;
    String sourceName;
    boolean sourceIsConst;
    String index;
    boolean indexIsConst;

    public InsertString(String destName, String sourceName, boolean sourceIsConst, String index, boolean indexIsConst) {
        this.destName = destName;
        this.sourceName = sourceName;
        this.sourceIsConst = sourceIsConst;
        this.index = index;
        this.indexIsConst = indexIsConst;
    }

    @Override
    public void evaluate(IRuntimeSession mySession) {
        IVariableField destField = mySession.getVariableField(new VariableName(this.destName));
        StringBuilder value = new StringBuilder(destField.getStringValue());
        String insert = this.sourceName;
        if (!this.sourceIsConst) {
            insert = this.getStringValue(mySession, new VariableName(this.sourceName));
        }
        int offset = 0;
        if (this.index != null) {
            String tmp = this.index;
            if (!this.indexIsConst) {
                tmp = this.getStringValue(mySession, new VariableName(this.index));
            }
            try {
                offset = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e) {
                throw new SCERuntimeException("Invalid index/offset value for InsertString operation.  Value must be a number!", (Exception)e);
            }
            if (offset < 0) {
                if (mySession.isTraceEnabled()) {
                    mySession.getTraceOutput().writeln(3, "Insert index cannot be < 0; changed value to be 0");
                }
                offset = 0;
            }
            if (offset >= value.length()) {
                if (mySession.isTraceEnabled()) {
                    mySession.getTraceOutput().writeln(3, "Insert index cannot be greater than the length of the source string; value will be appended.");
                }
                offset = value.length();
            }
        }
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(2, "Insert [" + insert + "] in [" + this.destName + "] at offset [" + offset + "]");
        }
        value.insert(offset, insert);
        destField.setValue(value.toString());
    }
}

