/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.restws;

import com.avaya.sce.runtime.connectivity.restws.CallService;
import com.avaya.sce.runtime.connectivity.restws.FixBugIn162VersionOfJSONDataSource;
import com.avaya.sce.runtime.connectivity.restws.FixBugIn162VersionOfJSONOMBuilder;
import com.avaya.sce.runtime.connectivity.restws.UniversalDataSource;
import com.avaya.sce.runtime.connectivity.restws.UniversalMessageBuilder;
import com.avaya.sce.runtime.connectivity.restws.WsOM;
import com.avaya.sce.runtime.connectivity.restws.WsParam;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.Stub;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.json.JSONBadgerfishMessageFormatter;
import org.apache.axis2.json.JSONBadgerfishOMBuilder;
import org.apache.axis2.json.JSONDataSource;
import org.apache.axis2.json.JSONMessageFormatter;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.json.JSONObject;
import org.json.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class Axis2RestStub
extends Stub {
    public CallService callService;
    public String targetEndpoint;
    public IRuntimeSession mySession;
    private int statusCode;
    private boolean rerun = false;
    private UniversalMessageBuilder builder = new UniversalMessageBuilder();

    public Axis2RestStub(CallService callService, IRuntimeSession mySession) {
        this.callService = callService;
        this.mySession = mySession;
    }

    public void setAxisService(AxisService axisService) {
        this._service = axisService;
        this.addAnonymousOperations();
    }

    public void setTargetEndpoint(String targetEndpoint) {
        this.targetEndpoint = targetEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(QName operationName) throws Exception {
        ConfigurationContext config = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
        AxisConfiguration axisConfig = config.getAxisConfiguration();
        axisConfig.addMessageBuilder("application/json/badgerfish", (Builder)new JSONBadgerfishOMBuilder());
        axisConfig.addMessageBuilder("application/json", (Builder)new FixBugIn162VersionOfJSONOMBuilder());
        axisConfig.addMessageBuilder("text/javascript", (Builder)new FixBugIn162VersionOfJSONOMBuilder());
        axisConfig.addMessageBuilder("text/json", (Builder)new FixBugIn162VersionOfJSONOMBuilder());
        axisConfig.addMessageFormatter("application/json/badgerfish", (MessageFormatter)new JSONBadgerfishMessageFormatter());
        axisConfig.addMessageFormatter("application/json", (MessageFormatter)new JSONMessageFormatter());
        axisConfig.addMessageFormatter("text/javascript", (MessageFormatter)new JSONMessageFormatter());
        axisConfig.addMessageFormatter("text/json", (MessageFormatter)new JSONMessageFormatter());
        if (this.callService.getOutputFormat().contains("_")) {
            String contentType = this.callService.getOutputFormat().substring(this.callService.getOutputFormat().indexOf(95) + 1);
            if (this.callService.getOutputFormat().toUpperCase().endsWith("BADGERFISH")) {
                axisConfig.addMessageBuilder(contentType, (Builder)new JSONBadgerfishOMBuilder());
                axisConfig.addMessageFormatter(contentType, (MessageFormatter)new JSONBadgerfishMessageFormatter());
            } else {
                axisConfig.addMessageBuilder(contentType, (Builder)new FixBugIn162VersionOfJSONOMBuilder());
                axisConfig.addMessageFormatter(contentType, (MessageFormatter)new JSONMessageFormatter());
            }
        }
        try {
            this._serviceClient = new ServiceClient(config, this._service);
            this._serviceClient.getOptions().setTo(new EndpointReference(Axis2RestStub.buildEndPointUrl(this.callService, this.targetEndpoint)));
            this._serviceClient.getOptions().setTimeOutInMilliSeconds((long)(this.callService.getTimeoutSeconds() * 1000));
            this._serviceClient.getOptions().setProperty("__CHUNKED__", (Object)Boolean.FALSE);
            this._serviceClient.getOptions().setProperty("enableREST", (Object)"true");
            this._serviceClient.getOptions().setProperty("ContentType", (Object)"application/x-www-form-urlencoded");
            this._serviceClient.getOptions().setProperty("httpContentNegotiation", (Object)"true");
            this._serviceClient.getOptions().setProperty("HTTP_METHOD", (Object)"GET");
            if ("POST".equals(this.callService.getHttpMethod())) {
                this._serviceClient.getOptions().setProperty("HTTP_METHOD", (Object)"POST");
                this._serviceClient.getOptions().setProperty("ContentType", (Object)"application/xml");
            }
            if ("PUT".equals(this.callService.getHttpMethod())) {
                this._serviceClient.getOptions().setProperty("HTTP_METHOD", (Object)"PUT");
                this._serviceClient.getOptions().setProperty("ContentType", (Object)"application/xml");
            }
            if ("DELETE".equals(this.callService.getHttpMethod())) {
                this._serviceClient.getOptions().setProperty("HTTP_METHOD", (Object)"DELETE");
            }
            HttpMethodParams methodParams = new HttpMethodParams();
            DefaultHttpMethodRetryHandler retryHandler = new DefaultHttpMethodRetryHandler(0, false);
            methodParams.setParameter("http.method.retry-handler", (Object)retryHandler);
            this._serviceClient.getOptions().setProperty("HTTP_METHOD_PARAMS", (Object)methodParams);
            List<Header> headerList = this.callService.processOutgoingHTTPHeaders();
            this._serviceClient.getOptions().setProperty("HTTP_HEADERS", headerList);
            this.callService.configureAuthentication(this._serviceClient, this);
            if (this.mySession.isTraceEnabled()) {
                this.mySession.getTraceOutput().writeln(1, "Web Service Request -> " + this._serviceClient.getOptions().getTo().getAddress());
            }
            OMElement element = this.run();
            if (this.rerun) {
                element = this.run();
                this.rerun = false;
            }
            MessageContext msgIn = this._serviceClient.getLastOperationContext().getMessageContext("In");
            Map inHeaders = (Map)msgIn.getProperty("TRANSPORT_HEADERS");
            this.callService.processIncommingHTTPHeaders(inHeaders);
            this.toODVariable(element);
        }
        catch (Exception e) {
            if (this.mySession.isTraceEnabled()) {
                this.mySession.getTraceOutput().writeln(4, "EXCEPTION: " + e.getMessage());
                throw e;
            }
        }
        finally {
            this._serviceClient.cleanupTransport();
        }
    }

    private OMElement run() throws Exception {
        OMElement element = null;
        try {
            element = this._serviceClient.sendReceive(this.getPayload());
            return element;
        }
        catch (AxisFault f) {
            String contentType;
            Object value;
            Map inHeaders;
            MessageContext msgIn = this._serviceClient.getLastOperationContext().getMessageContext("In");
            if (!(this.rerun || msgIn == null || (inHeaders = (Map)msgIn.getProperty("TRANSPORT_HEADERS")) == null || (value = inHeaders.get("Content-Type")) == null || !(value instanceof String) || (contentType = contentType.substring(0, (contentType = (String)value).indexOf(59) != -1 ? contentType.indexOf(59) : contentType.length())) == null || contentType.length() <= 0 || contentType.equals("application/json/badgerfish") || contentType.equals("application/json") || contentType.equals("text/json") || contentType.equals("text/javascript"))) {
                if (this.mySession.isTraceEnabled()) {
                    this.mySession.getTraceOutput().writeln(2, "Response had content type: " + contentType + ".  Retrying call with new type...");
                }
                AxisConfiguration axisConfig = this._serviceClient.getAxisConfiguration();
                axisConfig.addMessageBuilder(contentType, (Builder)this.builder);
                this.rerun = true;
                return element;
            }
            this.rerun = false;
            if (this.builder.getValue() != null) {
                OMSourcedElementImpl ele = new OMSourcedElementImpl(QName.valueOf("String"), OMAbstractFactory.getOMFactory(), (OMDataSource)new UniversalDataSource(this.builder.getValue()));
                return ele;
            }
            if (f.getMessage().startsWith("Transport error:")) {
                this.statusCode = Integer.parseInt(String.valueOf(f.getMessage().subSequence(17, 20)));
                if (this.statusCode >= 200 && this.statusCode < 400) {
                    if (this.mySession.isTraceEnabled()) {
                        this.mySession.getTraceOutput().writeln(2, f.getMessage().substring(17));
                    }
                    return element;
                }
                if (this.statusCode >= 400 && this.mySession.isTraceEnabled()) {
                    this.mySession.getTraceOutput().writeln(4, "HTTP TRANSPORT, " + f.getMessage().substring(17).toUpperCase());
                }
            } else if (f.getMessage().startsWith("com.ctc.wstx.exc.WstxEOFException: Unexpected EOF in prolog")) {
                this.statusCode = (Integer)msgIn.getProperty("transport.http.statusCode");
                if (this.statusCode >= 200 && this.statusCode < 400) {
                    if (this.mySession.isTraceEnabled()) {
                        this.mySession.getTraceOutput().writeln(2, "Unexpected EOF: Web service returned 0 bytes of data.");
                    }
                    return element;
                }
                if (this.statusCode >= 400 && this.mySession.isTraceEnabled()) {
                    this.mySession.getTraceOutput().writeln(4, "PARSE EXCEPTION: " + f.getMessage());
                }
            } else if (f.getCause() instanceof ConnectTimeoutException) {
                if (this.mySession.isTraceEnabled()) {
                    this.mySession.getTraceOutput().writeln(4, "CONNECTION TIMEOUT EXCEPTION: " + f.getMessage());
                }
            } else if (f.getCause() instanceof UnknownHostException) {
                if (this.mySession.isTraceEnabled()) {
                    this.mySession.getTraceOutput().writeln(4, "UNKNOWN HOST EXCEPTION: " + f.getMessage());
                }
            } else if (f.getCause() instanceof SSLException) {
                if (this.mySession.isTraceEnabled()) {
                    this.mySession.getTraceOutput().writeln(4, "SSL EXCEPTION: " + f.getMessage());
                }
            } else if (this.mySession.isTraceEnabled()) {
                this.mySession.getTraceOutput().writeln(4, "AXISFAULT during web service call: " + f.getMessage());
            }
            throw f;
        }
    }

    private OMElement getPayload() {
        if (this.callService.isUseBody() && ("POST".equals(this.callService.getHttpMethod()) || "PUT".equals(this.callService.getHttpMethod()))) {
            String body = new String(Base64.decode((String)this.callService.getMessageBody()));
            for (int i = 0; i < body.length(); ++i) {
                int j;
                if (body.charAt(i) != '_' || i + 1 >= body.length() || body.charAt(++i) != '{' || (j = body.indexOf(125, i)) + 1 >= body.length() || body.charAt(++j) != '_') continue;
                body = body.replace(body.substring(i - 1, j + 1), this.callService.getVariableValue(body.substring(i + 1, j - 1)));
            }
            if (body.startsWith("JSON")) {
                int j = body.indexOf(123);
                this._serviceClient.getOptions().setProperty("ContentType", (Object)"application/json");
                StringReader jsonReader = new StringReader(body.substring(j));
                FixBugIn162VersionOfJSONDataSource source = new FixBugIn162VersionOfJSONDataSource(jsonReader);
                OMSourcedElementImpl element = new OMSourcedElementImpl(QName.valueOf("payload"), OMAbstractFactory.getOMFactory(), (OMDataSource)source);
                return element;
            }
            try {
                DocumentBuilderFactory dBF = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = dBF.newDocumentBuilder();
                InputSource is = new InputSource(new ByteArrayInputStream(body.getBytes()));
                Document doc = builder.parse(is);
                return XMLUtils.toOM((Element)doc.getDocumentElement());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void toODVariable(OMElement ome) throws Exception {
        List<WsParam> outParams = this.callService.getOutParameters();
        WsOM model = null;
        String asString = null;
        boolean skip = false;
        if (ome == null) {
            return;
        }
        if (outParams.size() > 0) {
            StringWriter write;
            OMSourcedElementImpl sourcedOM;
            Object obj;
            if (ome instanceof OMSourcedElementImpl && ((OMSourcedElementImpl)ome).getDataSource() instanceof UniversalDataSource && (obj = ((UniversalDataSource)((OMSourcedElementImpl)ome).getDataSource()).getSource()) instanceof String) {
                asString = (String)obj;
                this.callService.parseRestReturn(asString);
                skip = true;
            }
            if (this.callService.isUseJavaObject() && !skip) {
                JSONDataSource jsonSource;
                if (this.callService.getOutputFormat().startsWith("JSON")) {
                    if (ome instanceof OMSourcedElementImpl) {
                        sourcedOM = (OMSourcedElementImpl)ome;
                        if (!(sourcedOM.getDataSource() instanceof JSONDataSource)) throw new Exception("Unknown object model data source.  Could not create JSON object from unknown source.");
                        jsonSource = (JSONDataSource)sourcedOM.getDataSource();
                        model = new WsOM(QName.valueOf(outParams.get(0).getDDVariableName()), new org.codehaus.jettison.json.JSONObject(jsonSource.getCompleteJOSNString()), "JSONObject", ome);
                        this.callService.parseRestReturn(model);
                    } else {
                        write = new StringWriter();
                        ome.serialize((Writer)write);
                        write.flush();
                        JSONObject temp = XML.toJSONObject((String)write.toString());
                        model = new WsOM(QName.valueOf(outParams.get(0).getDDVariableName()), new org.codehaus.jettison.json.JSONObject(temp.toString()), "JSONObject", ome);
                        this.callService.parseRestReturn(model);
                    }
                }
                if (this.callService.getOutputFormat().startsWith("XML")) {
                    model = new WsOM(QName.valueOf(outParams.get(0).getDDVariableName()), ome, "OMElement", ome);
                    this.callService.parseRestReturn(model);
                }
                if (this.callService.getOutputFormat().startsWith("Server Default") && this.callService.isUseJavaObject()) {
                    if (ome instanceof OMSourcedElementImpl) {
                        sourcedOM = (OMSourcedElementImpl)ome;
                        if (sourcedOM.getDataSource() instanceof JSONDataSource) {
                            jsonSource = (JSONDataSource)sourcedOM.getDataSource();
                            model = new WsOM(QName.valueOf(outParams.get(0).getDDVariableName()), new org.codehaus.jettison.json.JSONObject(jsonSource.getCompleteJOSNString()), "JSONObject", ome);
                            this.callService.parseRestReturn(model);
                        }
                    } else {
                        model = new WsOM(QName.valueOf(outParams.get(0).getDDVariableName()), ome, "OMElement", ome);
                        this.callService.parseRestReturn(model);
                    }
                }
                if (this.callService.getOutputFormat().startsWith("String")) {
                    if (ome instanceof OMSourcedElementImpl) {
                        sourcedOM = (OMSourcedElementImpl)ome;
                        if (sourcedOM.getDataSource() instanceof JSONDataSource) {
                            jsonSource = (JSONDataSource)sourcedOM.getDataSource();
                            asString = jsonSource.getCompleteJOSNString();
                            this.callService.parseRestReturn(asString);
                        }
                    } else {
                        asString = ome.toString();
                        this.callService.parseRestReturn(asString);
                    }
                }
            } else if (!skip) {
                JSONDataSource jsonSource;
                if (this.callService.getOutputFormat().startsWith("XML")) {
                    asString = ome.toString();
                    this.callService.parseRestReturn(asString);
                }
                if (this.callService.getOutputFormat().startsWith("JSON")) {
                    if (ome instanceof OMSourcedElementImpl) {
                        sourcedOM = (OMSourcedElementImpl)ome;
                        if (!(sourcedOM.getDataSource() instanceof JSONDataSource)) throw new Exception("Unknown object model data source.  Could not create JSON object from unknown source.");
                        jsonSource = (JSONDataSource)sourcedOM.getDataSource();
                        asString = jsonSource.getCompleteJOSNString();
                        this.callService.parseRestReturn(asString);
                    } else {
                        write = new StringWriter();
                        ome.serialize((Writer)write);
                        write.flush();
                        JSONObject json = XML.toJSONObject((String)write.toString());
                        asString = json.toString();
                        this.callService.parseRestReturn(asString);
                    }
                }
                if (this.callService.getOutputFormat().startsWith("Server Default")) {
                    if (ome instanceof OMSourcedElementImpl) {
                        sourcedOM = (OMSourcedElementImpl)ome;
                        if (sourcedOM.getDataSource() instanceof JSONDataSource) {
                            jsonSource = (JSONDataSource)sourcedOM.getDataSource();
                            asString = jsonSource.getCompleteJOSNString();
                            this.callService.parseRestReturn(asString);
                        }
                    } else {
                        asString = ome.toString();
                        this.callService.parseRestReturn(asString);
                    }
                }
                this.callService.parseRestReturn(new WsOM(QName.valueOf("StringToXPath"), ome, "OMElement", ome));
            }
            if (!this.mySession.isTraceEnabled()) return;
            if (model != null) {
                this.mySession.getTraceOutput().writeln(1, "Web Service Reply <- " + (model.getModelType().equals("JSONObject") ? ((org.codehaus.jettison.json.JSONObject)model.getModel()).toString() : (OMElement)model.getModel()));
                return;
            } else {
                if (asString == null) return;
                this.mySession.getTraceOutput().writeln(1, "Web Service Reply <- " + asString);
            }
            return;
        } else {
            if (!this.mySession.isTraceEnabled() || !"GET".equals(this.callService.getHttpMethod())) return;
            this.mySession.getTraceOutput().writeln(2, "Output parameters not specified");
        }
    }

    private static String getParamName(WsParam param) {
        try {
            return URLEncoder.encode(param.getName().getLocalPart(), "UTF-8");
        }
        catch (Exception e) {
            return param.getName().getLocalPart();
        }
    }

    private static String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (Exception e) {
            return value;
        }
    }

    public static String buildEndPointUrl(CallService callService, String endPoint) {
        List<WsParam> inParams = callService.getInParameters();
        String targetEndPoint = null;
        if (endPoint.length() > 0 && inParams.size() > 0) {
            String urlParams;
            if (callService.isUseQuery()) {
                urlParams = "";
                boolean queryBuilding = true;
                for (WsParam param : inParams) {
                    if (urlParams.length() > 0) {
                        if (param.getParamType() < 2) {
                            if (!queryBuilding) {
                                urlParams = urlParams + "?";
                                queryBuilding = true;
                            } else {
                                urlParams = urlParams + "&";
                            }
                        } else {
                            urlParams = urlParams + "/";
                            queryBuilding = false;
                        }
                    } else if (param.getParamType() == 2) {
                        queryBuilding = false;
                    }
                    String ddVarVal = Axis2RestStub.encodeValue(callService.getVariableValue(param.getDDVariableName()));
                    urlParams = urlParams + (param.getParamType() == 2 ? ddVarVal : Axis2RestStub.getParamName(param)) + (param.getParamType() < 2 ? "=" + ddVarVal : "");
                }
                targetEndPoint = urlParams.length() > 0 && inParams.get(0).getParamType() < 2 ? (endPoint.endsWith("/") ? endPoint.substring(0, endPoint.length() - 1) + (endPoint.contains("?") ? "" : "?") + urlParams : endPoint + (endPoint.contains("?") ? "" : "?") + urlParams) : (inParams.get(0).getParamType() == 2 ? (endPoint.endsWith("/") ? endPoint + urlParams : endPoint + '/' + urlParams) : endPoint);
            } else {
                urlParams = "";
                boolean queryBuilding = false;
                for (WsParam param : inParams) {
                    if (urlParams.length() > 0) {
                        if (param.getParamType() != 1) {
                            urlParams = urlParams + "/";
                            queryBuilding = false;
                        } else if (!queryBuilding) {
                            urlParams = urlParams + "?";
                            queryBuilding = true;
                        } else {
                            urlParams = urlParams + "&";
                        }
                    } else if (param.getParamType() == 1) {
                        queryBuilding = true;
                    }
                    String ddVarVal = Axis2RestStub.encodeValue(callService.getVariableValue(param.getDDVariableName()));
                    urlParams = urlParams + (param.getParamType() != 1 ? ddVarVal : Axis2RestStub.getParamName(param)) + (param.getParamType() == 1 ? "=" + ddVarVal : "");
                }
                targetEndPoint = urlParams.length() > 0 && inParams.get(0).getParamType() != 1 ? (endPoint.endsWith("/") ? endPoint + urlParams : (inParams.get(0).getParamType() == 1 ? (endPoint.endsWith("/") ? endPoint.substring(0, endPoint.length() - 1) + (endPoint.contains("?") ? "" : "?") + urlParams : endPoint + (endPoint.contains("?") ? "" : "?") + urlParams) : endPoint + '/' + urlParams)) : endPoint;
            }
        }
        String url = null;
        url = targetEndPoint != null ? targetEndPoint.replace(" ", "%20") : endPoint.replace(" ", "%20");
        return url;
    }

    public class AxisListener
    implements AxisCallback {
        private OMElement element;

        public AxisListener(OMElement element) {
            this.setElement(element);
        }

        public void setElement(OMElement element) {
            this.element = element;
        }

        public OMElement getElement() {
            return this.element;
        }

        public void onMessage(MessageContext mc) {
            this.setElement(mc.getEnvelope().getBuilder().getDocumentElement());
            this.notify();
        }

        public void onComplete() {
        }

        public void onError(Exception e) {
        }

        public void onFault(MessageContext mc) {
        }
    }
}

