/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.pdc.oceanaservices.operations;

import com.avaya.sce.pdc.oceanaservices.DataUtility;
import com.avaya.sce.pdc.oceanaservices.IOceanaServices;
import com.avaya.sce.pdc.oceanaservices.OceanaServices;
import com.avaya.sce.pdc.oceanaservices.OceanaServicesException;
import com.avaya.sce.pdc.oceanaservices.Utils;
import com.avaya.sce.pdc.oceanaservices.operations.OperationsHelper;
import com.avaya.sce.runtime.IPluggableExecutable;
import com.avaya.sce.runtimecommon.Debugging;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.ITraceInfo;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import org.json.JSONObject;

public class CreateContextWithSchema
extends Debugging
implements IPluggableExecutable {
    private String contextStoreIpVar;
    private String contextStoreIpField;
    private boolean csIpIsConstant;
    private String scVar;
    private String scField;
    private String leaseTimeVar;
    private String leaseTimeField;
    private boolean leaseTimeIsConstant;
    private String groupIdVar;
    private String groupIdField;
    private boolean groupIdIsConstant;
    private String journeyElementVar;
    private String journeyElementField;
    private boolean journeyElementIsConstant;
    private String topicVar;
    private String topicField;
    private boolean topicIsConstant;
    private String resultVar;
    private String resultField;
    private static final String OP = "Create Context with Schema";

    public CreateContextWithSchema(String contextStoreIpVar, String contextStoreIpField, boolean csIpIsConstant, String scVar, String scField, String leaseTimeVar, String leaseTimeField, boolean leaseTimeIsConstant, String groupIdVar, String groupIdField, boolean groupIdIsConstant, String journeyElementVar, String journeyElementField, boolean journeyElementIsConstant, String topicVar, String topicField, boolean topicIsConstant, String resultVar, String resultField) {
        this.contextStoreIpVar = contextStoreIpVar;
        this.contextStoreIpField = contextStoreIpField;
        this.csIpIsConstant = csIpIsConstant;
        this.scVar = scVar;
        this.scField = scField;
        this.leaseTimeVar = leaseTimeVar;
        this.leaseTimeField = leaseTimeField;
        this.leaseTimeIsConstant = leaseTimeIsConstant;
        this.groupIdVar = groupIdVar;
        this.groupIdField = groupIdField;
        this.groupIdIsConstant = groupIdIsConstant;
        this.journeyElementVar = journeyElementVar;
        this.journeyElementField = journeyElementField;
        this.journeyElementIsConstant = journeyElementIsConstant;
        this.topicVar = topicVar;
        this.topicField = topicField;
        this.topicIsConstant = topicIsConstant;
        this.resultVar = resultVar;
        this.resultField = resultField;
    }

    public String getId() {
        return Utils.getOceanaServices();
    }

    public String getTraceMessage() {
        return "Create Context with Schema ->" + this.scVar + ":" + this.scField;
    }

    public void execute(IRuntimeSession rtSession) {
        Exception ex;
        String resultMessage = "ERROR : ";
        SCESession mySession = (SCESession)rtSession;
        try {
            OperationsHelper.setFieldsToNull(this.scField);
            OperationsHelper.setFieldsToNull(this.resultField);
            OperationsHelper.setFieldsToNull(this.groupIdField);
            OperationsHelper.setFieldsToNull(this.journeyElementField);
            OperationsHelper.setFieldsToNull(this.leaseTimeField);
            OperationsHelper.setFieldsToNull(this.topicField);
            OperationsHelper.setFieldsToNull(this.contextStoreIpField);
            IVariableField data = mySession.getVariableField(new VariableName(this.scVar, this.scField));
            IVariableField result = mySession.getVariableField(new VariableName(this.resultVar, this.resultField));
            String leaseTime = Utils.getValueFromParameter(this.leaseTimeVar, this.leaseTimeField, this.leaseTimeIsConstant, mySession);
            if (leaseTime == null) {
                leaseTime = "";
            }
            String groupId = Utils.getValueFromParameter(this.groupIdVar, this.groupIdField, this.groupIdIsConstant, mySession);
            String topic = Utils.getValueFromParameter(this.topicVar, this.topicField, this.topicIsConstant, mySession);
            JSONObject dataJSON = new JSONObject(data.getStringValue());
            OceanaServices oceanaservices = new OceanaServices();
            oceanaservices.setMapToNullIfEmpty(dataJSON);
            OceanaServices.setField("groupId", dataJSON, groupId);
            OceanaServices.setField("topic", dataJSON, topic);
            String dataEmptyObjectToNull = dataJSON.toString();
            String journeyElement = Utils.getValueFromParameter(this.journeyElementVar, this.journeyElementField, this.journeyElementIsConstant, mySession);
            String contextStoreIp = Utils.getValueFromParameter(this.contextStoreIpVar, this.contextStoreIpField, this.csIpIsConstant, mySession);
            IOceanaServices oas = OperationsHelper.getOceanaServices(mySession, dataEmptyObjectToNull, OP);
            if (mySession.isTraceEnabled()) {
                ITraceInfo tr = mySession.getTraceOutput();
                tr.writeln(2, "Context Store cluster IP/FQDN: " + contextStoreIp + ", JSON Data: " + DataUtility.maskSensitiveDataJsonString(dataEmptyObjectToNull, tr) + ", Lease Time: " + leaseTime + ", Group Id: " + groupId + ", Journey Element:" + journeyElement + ", Topic: " + topic);
            }
            String value = oas.createContextWithSchema(dataEmptyObjectToNull, leaseTime, groupId, journeyElement, topic, mySession, contextStoreIp);
            OperationsHelper.traceOperationSuccess(mySession, OP);
            result.setValue(value);
            return;
        }
        catch (OceanaServicesException e) {
            resultMessage = resultMessage + "Fail Create Context with Schema : " + e;
            ex = e;
        }
        catch (Exception e) {
            resultMessage = resultMessage + "Could not Create Context with Schema : " + e;
            ex = e;
        }
        mySession.throwRTException(resultMessage, ex);
    }
}

