/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.restws;

import com.avaya.ade.common.utils.crypto.Crypto;
import com.avaya.ade.common.utils.xml.XML;
import com.avaya.runtimecommon.platforms.Toolkit;
import com.avaya.sce.runtime.connectivity.restws.Axis2RestStub;
import com.avaya.sce.runtime.connectivity.restws.VariableAccess;
import com.avaya.sce.runtime.connectivity.restws.WsHeader;
import com.avaya.sce.runtime.connectivity.restws.WsItem;
import com.avaya.sce.runtime.connectivity.restws.WsOM;
import com.avaya.sce.runtime.connectivity.restws.WsParam;
import com.avaya.sce.runtimecommon.Debugging;
import com.avaya.sce.runtimecommon.IExecutable;
import com.avaya.sce.runtimecommon.IPerformanceTracker;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.VariableName;
import com.avaya.sce.runtimecommon.VariableTypeException;
import com.avaya.sce.runtimecommon.config.IApplicationConfiguration;
import com.avaya.sce.runtimecommon.config.ICertificateKeystoreConfig;
import com.avaya.sce.runtimecommon.config.IProxySettings;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.httpclient.Header;
import org.w3c.dom.Document;

public class CallService
extends Debugging
implements IExecutable {
    public static final String ARRAYOF = "ArrayOf";
    public static final String NO_AUTHENTICATION = "No Authentication";
    public static final String BASIC_DIGEST = "Basic/Digest";
    public static final String MUTUAL_CERTIFICATE = "Mutual Certificate";
    public static final String NO_SECURITY = "No Security";
    protected String endPoint = null;
    protected String serviceName = null;
    protected QName operationName = null;
    protected String httpMethod = null;
    protected boolean useQuery = true;
    protected boolean useJavaObject = true;
    protected boolean useBody = false;
    protected List<WsParam> inParameters = null;
    protected List<WsParam> outParameters = null;
    protected String outputFormat = null;
    protected String messageBody = null;
    protected List<WsHeader> headers = null;
    protected String authentication = null;
    protected String userName = null;
    protected String password = null;
    protected boolean preemptive = false;
    protected String security = null;
    protected String port = null;
    protected int timeoutSeconds = 45;
    protected IRuntimeSession mySession = null;
    private String operationNSPrefix;

    public CallService(IRuntimeSession mySession) {
        this.mySession = mySession;
        this.inParameters = new ArrayList<WsParam>();
        this.outParameters = new ArrayList<WsParam>();
        this.headers = new ArrayList<WsHeader>();
    }

    protected String getVariableValue(String ddVariableName) {
        if (this.mySession == null) {
            return null;
        }
        VariableName varName = new VariableName(ddVariableName);
        if (CallService.isDDNull(this.mySession, varName)) {
            return null;
        }
        return VariableAccess.getSimple(this.mySession, varName);
    }

    protected String getVariableValue(WsHeader header) throws Exception {
        String result = null;
        VariableName varName = new VariableName(header.getVariable());
        result = CallService.isDDNull(this.mySession, varName) ? null : VariableAccess.getObject(this.mySession, varName).toString();
        return result;
    }

    protected static boolean isDDNull(IRuntimeSession mySession, VariableName varName) {
        IVariableField var = null;
        try {
            var = mySession.getVariableField(varName);
        }
        catch (VariableTypeException ve) {
            return false;
        }
        if (var == null) {
            return false;
        }
        Object varValue = var.getObjectValue();
        if (varValue == null) {
            return true;
        }
        return var.getStringValue().equals("__DD_NULL");
    }

    protected void setVariableValue(WsItem param, Object value) {
        if (value == null) {
            for (int i = 0; i < this.outParameters.size(); ++i) {
                if (this.mySession.isTraceEnabled()) {
                    this.mySession.getTraceOutput().writeln(3, "Return value is null for " + this.outParameters.get(i).getDDVariableName());
                }
                VariableName varName = new VariableName(this.outParameters.get(i).getDDVariableName());
                VariableAccess.setDDNull(this.mySession, varName);
            }
            return;
        }
        VariableName varName = new VariableName(param.getDDVariableName());
        if (this.useJavaObject) {
            VariableAccess.storeObject(this.mySession, varName, value);
        }
    }

    protected void setVariableValue(String variableName, String value) {
        this.setVariableValue(new VariableName(variableName), value);
    }

    protected void setVariableValue(VariableName varName, String value) {
        if (value == null) {
            if (this.mySession.isTraceEnabled()) {
                this.mySession.getTraceOutput().writeln(3, "Return value is null for " + varName);
            }
            VariableAccess.setDDNull(this.mySession, varName);
            return;
        }
        VariableAccess.storeSimple(this.mySession, varName, value, "string");
    }

    protected void parseRestReturn(Object value) throws Exception {
        if (value instanceof WsOM) {
            WsOM model = (WsOM)value;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (model.getRaw() == null) {
                return;
            }
            model.getRaw().serialize((OutputStream)out);
            Document doc = XML.getDocumentFromXMLString((String)out.toString());
            XPathFactory xFactory = XPathFactory.newInstance();
            XPath xPath = xFactory.newXPath();
            for (WsParam outParam : this.outParameters) {
                if ("(ALL)".equals(outParam.getName().getLocalPart())) {
                    if (model.getName().getLocalPart().equals("StringToXPath")) continue;
                    this.setVariableValue(outParam, model.getModel());
                    continue;
                }
                String xPathStr = outParam.getName().getLocalPart();
                for (int i = 0; i < xPathStr.length(); ++i) {
                    if (xPathStr.charAt(i) != '{') continue;
                    int end = xPathStr.indexOf(125);
                    String var = xPathStr.substring(i + 1, end);
                    String varValue = this.getVariableValue(var);
                    xPathStr = xPathStr.substring(0, i) + varValue + xPathStr.substring(end + 1);
                }
                String xValue = xPath.evaluate(xPathStr, doc);
                this.setVariableValue(outParam.getDDVariableName(), xValue);
            }
        } else {
            for (WsParam outParam : this.outParameters) {
                if (!"(ALL)".equals(outParam.getName().getLocalPart())) continue;
                this.setVariableValue(outParam.getDDVariableName(), (String)value);
            }
        }
    }

    public Axis2RestStub getAxis2Stub() {
        return new Axis2RestStub(this, this.mySession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        long start = System.currentTimeMillis();
        try {
            if (this.mySession.isTraceEnabled()) {
                this.mySession.getTraceOutput().writeln(2, "Starting REST web service operation [" + this.serviceName + "]");
            }
            this.mySession.setupProxy();
            Axis2RestStub stub = this.getAxis2Stub();
            AxisService axisService = this.getAxisService();
            axisService.addOperation(this.getAxisOperation());
            stub.setAxisService(axisService);
            stub.setTargetEndpoint(this.endPoint);
            stub.execute(this.operationName);
            stub.cleanup();
        }
        catch (Exception e) {
            this.mySession.throwRTException("Error on Web Service call:", e);
        }
        finally {
            long stop = System.currentTimeMillis();
            IPerformanceTracker tracker = this.mySession.getPerformanceTracker();
            if (tracker != null) {
                tracker.update("_avaya-rest", stop - start, this.mySession.getCurrentLocationId());
            }
        }
    }

    public AxisService getAxisService() {
        UUID uuid = UUID.randomUUID();
        String name = this.serviceName + "_" + uuid;
        AxisService axisService = new AxisService(name);
        return axisService;
    }

    public AxisOperation getAxisOperation() {
        OutInAxisOperation axisOperation = new OutInAxisOperation();
        axisOperation.setName(this.operationName);
        return axisOperation;
    }

    public void configureAuthentication(ServiceClient _serviceClient, Axis2RestStub stub) throws NoSuchAlgorithmException, KeyManagementException, MalformedURLException {
        if (this.authentication != null && BASIC_DIGEST.equals(this.authentication)) {
            if (this.mySession.isTraceEnabled()) {
                this.mySession.getTraceOutput().writeln(2, "Using Basic/Digest authentication for web service call");
            }
            HttpTransportProperties.Authenticator auth = new HttpTransportProperties.Authenticator();
            if (this.userName != null && this.userName.length() > 0) {
                auth.setUsername(this.userName);
            }
            if (this.password != null && this.password.length() > 0) {
                auth.setPassword(this.password);
            }
            auth.setPreemptiveAuthentication(false);
            if (this.preemptive) {
                auth.setPreemptiveAuthentication(true);
            }
            _serviceClient.getOptions().setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)auth);
        }
        if (this.security != null) {
            if (!NO_SECURITY.equals(this.security)) {
                int portInt;
                IApplicationConfiguration config = Toolkit.getConfig();
                ICertificateKeystoreConfig cert = config.getCertificateConfig();
                int n = portInt = this.port.equals("") ? 443 : Integer.parseInt(this.port);
                if (MUTUAL_CERTIFICATE.equals(this.authentication)) {
                    stub._getServiceClient().getOptions().setProperty("CUSTOM_PROTOCOL_HANDLER", (Object)cert.getProtocolForPort(this.security, true, portInt));
                } else {
                    stub._getServiceClient().getOptions().setProperty("CUSTOM_PROTOCOL_HANDLER", (Object)cert.getProtocolForPort(this.security, false, portInt));
                }
                if (this.mySession.isTraceEnabled()) {
                    this.mySession.getTraceOutput().writeln(2, "Using " + this.authentication + " for web service call, keystore : " + cert.getKeystoreLocationURL() + " on port : " + portInt);
                }
                String addr = _serviceClient.getOptions().getTo().getAddress();
                try {
                    URL url = new URL(addr);
                    if (!"https".equals(url.getProtocol())) {
                        addr = "https://" + addr.substring(addr.indexOf(47) + 2);
                        url = new URL(addr);
                    }
                    if (!this.port.equals("")) {
                        String file = url.getFile();
                        String host = url.getHost();
                        String protocol = url.getProtocol();
                        url = new URL(protocol, host, Integer.parseInt(this.port), file);
                        addr = url.toString();
                    }
                    IApplicationConfiguration appConfig = Toolkit.getConfig((String)"");
                    IProxySettings proxy = appConfig.getProxySettings();
                    String host = proxy.getSecureProxyHost();
                    String port = proxy.getSecureProxyPort();
                    if (host != null && host.length() > 0 && port != null && port.length() > 0) {
                        HttpTransportProperties.ProxyProperties proxyProperties = new HttpTransportProperties.ProxyProperties();
                        proxyProperties.setProxyName(host);
                        proxyProperties.setProxyPort(Integer.parseInt(port));
                        _serviceClient.getOptions().setProperty("PROXY", (Object)proxyProperties);
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                _serviceClient.getOptions().setTo(new EndpointReference(addr));
            }
            if (NO_SECURITY.equals(this.security)) {
                // empty if block
            }
        }
    }

    public void addInParameter(WsParam wsParam) {
        this.inParameters.add(wsParam);
    }

    public void setEndPoint(String name) {
        if (name != null && name != "") {
            this.endPoint = name;
        }
    }

    public void setOperation(QName name) {
        this.operationName = name;
    }

    public void setOperationNSPrefix(String operationNSPrefix) {
        this.operationNSPrefix = operationNSPrefix;
    }

    public String getOperationNSPrefix() {
        return this.operationNSPrefix;
    }

    public QName getOperationName() {
        return this.operationName;
    }

    public void setWrappedStyle(boolean wrappedStyle) {
    }

    public void addOutParameter(WsParam wsParam) {
        this.outParameters.add(wsParam);
    }

    public void addHTTPHeader(String name, String varName, int direction) {
        this.headers.add(new WsHeader(name, varName, direction));
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public boolean isUseQuery() {
        return this.useQuery;
    }

    public void setUseQuery(String useQuery) {
        this.useQuery = Boolean.valueOf(useQuery);
    }

    public boolean isUseJavaObject() {
        return this.useJavaObject;
    }

    public boolean isUseBody() {
        return this.useBody;
    }

    public void setUseBody(String useBody) {
        this.useBody = Boolean.valueOf(useBody);
    }

    public void setUseJavaObject(String useJavaObject) {
        this.useJavaObject = Boolean.valueOf(useJavaObject);
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setAuthenticationFromParameter(String authenticationParameterName) {
        this.authentication = this.mySession.getParameter(authenticationParameterName);
    }

    public void setEndpointFromParameter(String parameterName) {
        this.endPoint = this.mySession.getParameter(parameterName);
    }

    public void setUsernameFromParameter(String parameterName) {
        this.userName = this.mySession.getParameter(parameterName);
    }

    public void setPasswordFromParameter(String passwordParameterName) {
        String password = this.mySession.getParameter(passwordParameterName);
        try {
            this.password = new String(Crypto.decrypt((byte[])password.getBytes()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUserNameFromParameter(String userNameParameterName) {
        this.userName = this.mySession.getParameter(userNameParameterName);
    }

    public void setPreemptiveFromParameter(String preemptiveParameterName) {
        String preempt = this.mySession.getParameter(preemptiveParameterName);
        this.preemptive = Boolean.valueOf(preempt);
    }

    public void setSecurityFromParameter(String securityParameterName) {
        String security;
        this.security = security = this.mySession.getParameter(securityParameterName);
    }

    public void setPortFromParameter(String portParameterName) {
        String port;
        this.port = port = this.mySession.getParameter(portParameterName);
    }

    public List<WsParam> getInParameters() {
        return this.inParameters;
    }

    public List<WsParam> getOutParameters() {
        return this.outParameters;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        for (char c : outputFormat.toCharArray()) {
            if (c != '_') continue;
        }
        this.outputFormat = outputFormat;
    }

    public String getMessageBody() {
        return this.messageBody;
    }

    public void setMessageBody(String body) {
        this.messageBody = body;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSecondsFromParameter(String timeoutParameterName) {
        String timeout = this.mySession.getParameter(timeoutParameterName);
        try {
            this.timeoutSeconds = Integer.parseInt(timeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private WsHeader getIncommingHTTPHeader(String headerName) {
        for (WsHeader header : this.headers) {
            if (header.getDirection() == 1 || !header.getName().equalsIgnoreCase(headerName)) continue;
            return header;
        }
        return null;
    }

    public Hashtable<String, String> getOutgoingHTTPHeaders() {
        Hashtable<String, String> httpHeaders = new Hashtable<String, String>();
        for (WsHeader header : this.headers) {
            if (header.getDirection() == 0) continue;
            try {
                String value = this.getVariableValue(header);
                httpHeaders.put(header.getName(), value);
                if (!this.mySession.isTraceEnabled()) continue;
                this.mySession.getTraceOutput().writeln(1, "Adding HTTP header [" + header.getName() + ": " + value + "]");
            }
            catch (Exception e) {
                if (!this.mySession.isTraceEnabled()) continue;
                this.mySession.getTraceOutput().writeln(4, "Failed adding http header [" + header.getName() + "] " + e.getMessage());
            }
        }
        return httpHeaders;
    }

    public List<Header> processOutgoingHTTPHeaders() {
        ArrayList<Header> list = null;
        Hashtable<String, String> headers = this.getOutgoingHTTPHeaders();
        if (headers.size() > 0) {
            list = new ArrayList<Header>();
            Set<String> keys = headers.keySet();
            for (String next : keys) {
                Header head = new Header(next, headers.get(next));
                list.add(head);
            }
        }
        return list;
    }

    public void processIncommingHTTPHeaders(Map<String, Header> inHeaders) {
        if (inHeaders != null) {
            for (String headerName : inHeaders.keySet()) {
                WsHeader wsHeader = this.getIncommingHTTPHeader(headerName);
                if (wsHeader == null) continue;
                Header objValue = inHeaders.get(headerName);
                if (objValue instanceof String) {
                    String value = (String)objValue;
                    if (this.mySession.isTraceEnabled()) {
                        this.mySession.getTraceOutput().writeln(1, "Collecting HTTP header [" + headerName + " = " + value + "]");
                    }
                    try {
                        this.setVariableValue(new VariableName(wsHeader.getVariable()), value);
                    }
                    catch (Exception e) {
                        if (!this.mySession.isTraceEnabled()) continue;
                        this.mySession.getTraceOutput().writeln(4, "Failed updating variable [" + wsHeader.getVariable() + "] " + e.getMessage());
                    }
                    continue;
                }
                if (!this.mySession.isTraceEnabled()) continue;
                this.mySession.getTraceOutput().writeln(4, "Unexpected formate of header: [" + objValue.getClass().getName() + "]");
            }
        }
    }
}

