/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.vp.admin.variables.runtime;

import com.avaya.ade.common.utils.xml.XML;
import com.avaya.ade.common.utils.xml.XmlWriter;
import com.avaya.vp.admin.variables.runtime.AdminVarCache;
import com.avaya.vp.admin.variables.runtime.IAdminVariableInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdminVariableInfo
extends HttpServlet
implements IAdminVariableInfo {
    private static final long serialVersionUID = 1L;
    private static final String SERVLET_NAME = "AdminVariableInfo";

    public void init() throws ServletException {
        try {
            String dataPath = this.getServletContext().getRealPath("/data");
            File file = new File(dataPath + "/" + "adminvarinfo.xml");
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                AdminVarCache.loadAdminMetaInfo(fis);
            }
        }
        catch (FileNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/xml; charset=UTF-8");
        InputStream fis = null;
        String dataPath = this.getServletContext().getRealPath("/data");
        ArrayList<String> moduleNames = new ArrayList<String>();
        if (dataPath != null) {
            fis = new FileInputStream(dataPath + "/" + "project.module");
        } else {
            try {
                fis = this.getInputStreamByURL(req, req.getContextPath() + "/data" + "/" + "project.module", false);
            }
            catch (Exception e) {
                fis.close();
                throw new ServletException((Throwable)e);
            }
        }
        try {
            Document doc = XML.getDocument((InputStream)fis);
            NodeList nodeList = doc.getElementsByTagName("moduleref");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i).getAttributes().getNamedItem("name");
                moduleNames.add(node.getNodeValue());
            }
        }
        catch (Exception e) {
            fis.close();
            throw new ServletException((Throwable)e);
        }
        if (dataPath != null) {
            fis = new FileInputStream(dataPath + "/" + "adminvarinfo.xml");
        } else {
            try {
                fis = this.getInputStreamByURL(req, req.getContextPath() + "/data" + "/" + "adminvarinfo.xml", false);
            }
            catch (Exception e) {
                fis.close();
                throw new ServletException((Throwable)e);
            }
        }
        Document main = null;
        Node mainFieldsNode = null;
        try {
            main = XML.getDocument((InputStream)fis);
            mainFieldsNode = main.getElementsByTagName("PageletFields").item(0);
        }
        catch (Exception e) {
            fis.close();
            throw new ServletException((Throwable)e);
        }
        for (String moduleName : moduleNames) {
            try {
                String fileNamePath = "/" + moduleName + "/" + SERVLET_NAME;
                InputStream is = this.getInputStreamByURL(req, fileNamePath, false);
                Document moduleDoc = XML.getDocument((InputStream)is);
                Node convLeaseNode = null;
                NodeList fields = moduleDoc.getElementsByTagName("PageletField");
                for (int i = 0; i < fields.getLength(); ++i) {
                    Node field = fields.item(i);
                    NodeList fieldAttrs = field.getChildNodes();
                    for (int j = 0; j < fieldAttrs.getLength(); ++j) {
                        String attrName = fieldAttrs.item(j).getNodeName();
                        if (!attrName.equals("FieldName")) continue;
                        String name = AdminVariableInfo.getText(fieldAttrs.item(j));
                        if (name.equals("avayaConversationLease")) {
                            convLeaseNode = field;
                            continue;
                        }
                        if (name.indexOf(".") >= 0) continue;
                        AdminVariableInfo.setText(fieldAttrs.item(j), moduleName + "." + name);
                    }
                    if (mainFieldsNode == null) {
                        Element fieldsElem = main.createElement("PageletFields");
                        mainFieldsNode = main.getElementsByTagName("PageletBody").item(0).appendChild(fieldsElem);
                    }
                    if (this.isFieldExist(mainFieldsNode, field)) continue;
                    mainFieldsNode.appendChild(main.importNode(field, true));
                }
                if (convLeaseNode == null) continue;
                convLeaseNode.getParentNode().removeChild(convLeaseNode);
            }
            catch (Exception e) {
                System.out.println("Error reading configurable variables from module - " + moduleName + ";exception:" + e);
                e.printStackTrace();
            }
        }
        fis.close();
        StringBuffer sb = new StringBuffer();
        XmlWriter xmlWriter = new XmlWriter();
        xmlWriter.write(main, sb);
        resp.getWriter().write(sb.toString());
    }

    private URL getURL(HttpServletRequest request, String fileNamePath, boolean useLocalHost) throws ServletException {
        String protocol = "http";
        if (request.isSecure()) {
            protocol = "https";
        }
        String host = request.getServerName();
        if (useLocalHost) {
            host = "localhost";
        }
        int port = request.getServerPort();
        URL url = null;
        try {
            url = new URL(protocol, host, port, fileNamePath);
        }
        catch (MalformedURLException e) {
            throw new ServletException("Error creating URL - " + protocol + "://" + host + ":" + port, (Throwable)e);
        }
        return url;
    }

    private InputStream getInputStreamByURL(HttpServletRequest request, String fileNamePath, boolean useLocalHost) throws Exception {
        InputStream is = null;
        URL url = this.getURL(request, fileNamePath, false);
        try {
            is = this.getInputStreamByURL(url);
        }
        catch (Exception e) {
            System.out.println("OD Debugging: can not access url on server " + request.getServerName() + "; try localhost instead.");
            url = this.getURL(request, fileNamePath, true);
            try {
                is = this.getInputStreamByURL(url);
            }
            catch (Exception e2) {
                throw new Exception("Can not access url on server using either the server ip or localhost.");
            }
        }
        return is;
    }

    private InputStream getInputStreamByURL(URL url) throws Exception {
        HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
        httpCon.setRequestMethod("GET");
        httpCon.connect();
        InputStream is = httpCon.getInputStream();
        return is;
    }

    private static String getText(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 3) continue;
            return children.item(i).getNodeValue();
        }
        return "";
    }

    private static void setText(Node node, String text) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 3) continue;
            children.item(i).setNodeValue(text);
        }
    }

    private boolean isFieldExist(Node mainFieldsNode, Node node) {
        Node field;
        String name;
        boolean isExist = false;
        NodeList nodeList = mainFieldsNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength() && !(isExist = (name = this.getFieldName(field = nodeList.item(i))).equals(this.getFieldName(node))); ++i) {
        }
        return isExist;
    }

    private String getFieldName(Node field) {
        String name = "";
        NodeList fieldAttrs = field.getChildNodes();
        for (int i = 0; i < fieldAttrs.getLength(); ++i) {
            String attrName = fieldAttrs.item(i).getNodeName();
            if (!attrName.equals("FieldName")) continue;
            name = AdminVariableInfo.getText(fieldAttrs.item(i));
            break;
        }
        return name;
    }
}

