/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.pdc.oceanaservices.operations;

import com.avaya.sce.pdc.oceanaservices.Utils;
import com.avaya.sce.pdc.oceanaservices.operations.OperationsHelper;
import com.avaya.sce.runtime.IPluggableExecutable;
import com.avaya.sce.runtimecommon.Debugging;
import com.avaya.sce.runtimecommon.ICollection;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONParser
extends Debugging
implements IPluggableExecutable {
    private static final Logger LOGGER = Logger.getLogger(JSONParser.class.getName());
    private String destVar;
    private String destField;
    private String srcVar;
    private String srcField;
    private String pathVar;
    private String pathField;
    private boolean pathIsConstant;
    private static final String OP = "Parse JSON";

    public JSONParser(String srcVar, String srcField, String destVar, String destField, String pathVar, String pathField, boolean pathIsConstant) {
        this.srcVar = srcVar;
        this.srcField = srcField;
        this.destVar = destVar;
        this.destField = destField;
        this.pathVar = pathVar;
        this.pathField = pathField;
        this.pathIsConstant = pathIsConstant;
    }

    public String getId() {
        return Utils.getOceanaServices();
    }

    public String getTraceMessage() {
        return "Parse JSON ->" + this.destVar + ":" + this.destField;
    }

    public void execute(IRuntimeSession rtSession) {
        String resultMessage = "ERROR : ";
        SCESession mySession = (SCESession)rtSession;
        Exception ex = null;
        try {
            OperationsHelper.setFieldsToNull(this.destField);
            OperationsHelper.setFieldsToNull(this.pathField);
            OperationsHelper.setFieldsToNull(this.srcField);
            IVariableField dest = mySession.getVariableField(new VariableName(this.destVar, this.destField));
            IVariableField src = mySession.getVariableField(new VariableName(this.srcVar, this.srcField));
            String path = Utils.getValueFromParameter(this.pathVar, this.pathField, this.pathIsConstant, mySession);
            if (rtSession.isTraceEnabled()) {
                rtSession.getTraceOutput().writeln(1, "Path : " + path);
            }
            path = Utils.substituteVaraiables(mySession, path);
            if (rtSession.isTraceEnabled()) {
                rtSession.getTraceOutput().writeln(1, "True Path : " + path);
            }
            String jsonStr = src.getStringValue();
            JSONObject json = new JSONObject(jsonStr);
            this.parseJson(mySession, dest, json, path);
        }
        catch (Exception e) {
            resultMessage = resultMessage + "Could not Parse JSON : " + e;
            ex = e;
            mySession.throwRTException(resultMessage, ex);
        }
    }

    private void parseJson(SCESession mySession, IVariableField dest, JSONObject json, String path) {
        Object value = null;
        String[] segments = path.split("/");
        for (int i = 0; i < segments.length; ++i) {
            JSONObject temp;
            if (i == segments.length - 1) {
                value = json.get(segments[i]);
                continue;
            }
            try {
                temp = json.getJSONObject(segments[i]);
            }
            catch (JSONException e) {
                temp = new JSONObject();
                json.put(segments[i], (Object)temp);
                LOGGER.log(Level.WARNING, "", e);
            }
            json = temp;
        }
        if (value instanceof JSONArray) {
            IVariable var = mySession.getVariable(this.destVar);
            ICollection collection = var.isCollection() ? var.getCollection() : var.addCollection();
            JSONArray j = (JSONArray)value;
            for (int i = 0; i < j.length(); ++i) {
                String str = j.getString(i);
                dest.setValue(str);
                collection.append();
            }
            collection.reset();
            collection.next();
        } else if (value != null) {
            dest.setValue(value.toString());
        }
    }
}

