/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.pdc.oceanaservices.operations;

import com.avaya.runtimecommon.platforms.Toolkit;
import com.avaya.sce.pdc.oceanaservices.DataUtility;
import com.avaya.sce.pdc.oceanaservices.IOceanaServices;
import com.avaya.sce.pdc.oceanaservices.Simulation;
import com.avaya.sce.pdc.oceanaservices.Utils;
import com.avaya.sce.runtimecommon.IPlatformParams;
import com.avaya.sce.runtimecommon.ITraceInfo;
import com.avaya.sce.runtimecommon.PlatformSettings;
import com.avaya.sce.runtimecommon.SCESession;

final class OperationsHelper {
    private OperationsHelper() {
    }

    static IOceanaServices getOceanaServices(SCESession mySession, String data, String operation) {
        IOceanaServices oas;
        IPlatformParams params = Toolkit.getToolkit((PlatformSettings)mySession.getPlatformSettings()).getPlatformParamsObject(mySession);
        if (mySession.getPlatformSettings().getPlatform().equalsIgnoreCase("Experience Portal")) {
            if (mySession.isTraceEnabled()) {
                ITraceInfo tr = mySession.getTraceOutput();
                tr.writeln(1, "Platform:" + operation + " -> ");
            }
            oas = Utils.getService(mySession);
        } else if (params.getValue("__VPEDContextStore") != null && !"".equals(params.getValue("__VPEDContextStore"))) {
            if (mySession.isTraceEnabled()) {
                ITraceInfo tr = mySession.getTraceOutput();
                tr.writeln(1, "Platform:" + operation + " -> ");
                tr.writeln(1, "__VPEDContextStore:\"" + params.getValue("__VPEDContextStore") + "\", the PDC will runs against that URL to the existing Oceana environment. ");
            }
            oas = Utils.getService(mySession);
        } else {
            oas = new Simulation(mySession);
            if (mySession.isTraceEnabled()) {
                ITraceInfo tr = mySession.getTraceOutput();
                tr.writeln(1, "Simulation:" + operation + " -> ");
                if (data != null) {
                    tr.writeln(1, "        data: " + DataUtility.maskSensitiveDataJsonString(data, tr));
                }
            }
        }
        return oas;
    }

    static void traceContextId(SCESession mySession, String contextId) {
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(1, "    contextId: " + contextId);
        }
    }

    static void traceCustomerId(SCESession mySession, String customerId) {
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(1, "    customerId: " + customerId);
        }
    }

    static void traceOperationSuccess(SCESession mySession, String operation) {
        OperationsHelper.traceOperationSuccess(mySession, operation, null);
    }

    static void traceOperationSuccess(SCESession mySession, String operation, String id) {
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(2, "Okay " + operation + (id != null ? " " + id : ""));
        }
    }

    public static void setFieldsToNull(String variable) {
        if (variable != null && variable.equals("")) {
            variable = null;
        }
    }
}

