/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.html.genmodel;

import com.avaya.sce.runtime.html.genmodel.ChoiceInput;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;

public class MenuChoiceInput
extends ChoiceInput {
    public static final String TYPE_RADIO = "Radio";
    public static final String TYPE_DROPDOWN = "Dropdown";
    private String next;
    private String icon;
    private String description;

    public MenuChoiceInput(String name, String label, String choiceVariable, String choiceTextset, ChoiceInput.ChoiceType choiceType, String next, String icon, String description) {
        super(name, label, TYPE_DROPDOWN, choiceVariable, choiceTextset, choiceType);
        this.next = next;
        this.icon = icon;
        this.description = description;
    }

    public String getNext() {
        return this.next;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getDescription() {
        return this.description;
    }

    public static String getDescriptionTextset(String name, SCESession session) {
        return MenuChoiceInput.getTextset(name, session);
    }

    public static String getChoice(String name, ChoiceInput.ChoiceType cType, SCESession session) {
        if (cType == ChoiceInput.ChoiceType.TEXTSET) {
            return MenuChoiceInput.getTextset(name, session);
        }
        return MenuChoiceInput.getVariableChoice(name, session);
    }

    private static String getVariableChoice(String name, SCESession session) {
        if (!name.isEmpty() && session != null) {
            VariableName varName = new VariableName(name);
            String textId = session.getVariableField(varName).getStringValue();
            if (textId.indexOf(":") < 0) {
                return textId;
            }
            return MenuChoiceInput.getTextset(textId, session);
        }
        return name;
    }
}

