/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.html.genmodel;

import com.avaya.sce.runtime.html.genmodel.Element;
import com.avaya.sce.runtime.html.genmodel.WebForm;
import com.avaya.sce.runtimecommon.SCESession;

public class TextAreaInput
extends Element {
    private String name;
    private String label;
    private int rows;
    private int cols;
    private String required;

    public TextAreaInput(String name, String label, int rows, int cols, String required) {
        this.name = name;
        this.label = label;
        this.rows = rows;
        this.cols = cols;
        this.required = required;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public String getRequired() {
        if (this.required.equals("Yes")) {
            return "required";
        }
        return "";
    }

    @Override
    public String toJsonString(WebForm form, SCESession session) {
        StringBuffer jsonSb = new StringBuffer("{\"inputtype\":\"textarea\",\"name\":\"");
        String label = form.getL18nLabel(this.getName(), session, this.getLabel());
        jsonSb.append(this.getName());
        jsonSb.append("\",");
        jsonSb.append("\"label\":\"");
        jsonSb.append(label);
        jsonSb.append("\",");
        jsonSb.append("\"rows\":");
        jsonSb.append(this.getRows());
        jsonSb.append(",");
        jsonSb.append("\"cols\":");
        jsonSb.append(this.getCols());
        jsonSb.append(",");
        jsonSb.append("\"required\":\"");
        jsonSb.append(this.getRequired());
        jsonSb.append("\"}");
        return jsonSb.toString();
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }
}

