/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.varoperations;

import com.avaya.sce.runtime.varoperations.AssignmentOperation;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.VariableName;

public class HexToStringDecoder
extends AssignmentOperation {
    private String destName;
    private String sourceName;

    public HexToStringDecoder(String destName, String sourceName) {
        this.destName = destName;
        this.sourceName = sourceName;
    }

    @Override
    public void evaluate(IRuntimeSession mySession) {
        IVariableField destField = mySession.getVariableField(new VariableName(this.destName));
        String source = this.getStringValue(mySession, new VariableName(this.sourceName));
        String result = "";
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(2, "HexToStringDecoder convert [" + this.sourceName + "] to [" + this.destName + "]");
        }
        if (source.length() % 2 == 1) {
            if (mySession.isTraceEnabled()) {
                mySession.getTraceOutput().writeln(4, "Hex string is invalid; the length is not an even number.");
            }
            return;
        }
        try {
            byte[] data = new byte[source.length() / 2];
            for (int i = 0; i < source.length(); i += 2) {
                data[i / 2] = Integer.decode("0x" + source.charAt(i) + source.charAt(i + 1)).byteValue();
            }
            result = new String(data, "UTF-8");
            destField.setValue(result);
        }
        catch (Exception e) {
            throw new SCERuntimeException("Error converting hex string character codes", e);
        }
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(2, "HexToStringDecoder conversion result - [" + result.toString() + "]");
        }
        destField.setValue(result.toString());
    }
}

