/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.varoperations;

import com.avaya.sce.runtime.varoperations.AssignmentOperation;
import com.avaya.sce.runtime.varoperations.PrepareAAI;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.VariableName;

public class ReplaceAAIData
extends AssignmentOperation {
    String origAAIVar;
    String asaiVar;
    String collDigitsVar;
    String resultVar;

    public ReplaceAAIData(String origAAIVar, String asaiVar, String collDigitsVar, String resultVar) {
        this.origAAIVar = origAAIVar;
        this.asaiVar = asaiVar;
        this.collDigitsVar = collDigitsVar;
        this.resultVar = resultVar;
    }

    @Override
    public void evaluate(IRuntimeSession mySession) {
        String savedFA;
        String value;
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(2, "replacing AAI data [only shared mode supported] origAAIVar [" + this.origAAIVar + "]  with asaiVar [" + this.asaiVar + "] collDigitVar [" + this.collDigitsVar + "]");
        }
        String result = "";
        if (this.origAAIVar.length() != 0) {
            IVariableField aaiVarField = mySession.getVariableField(new VariableName(this.origAAIVar));
            String origAAI = aaiVarField.getStringValue();
            if (origAAI.length() < 6) {
                mySession.getTraceOutput().writeln(1, "Original AAI value is empty.");
                return;
            }
            result = origAAI;
        } else {
            mySession.throwRTException("Orginal AAI variable is not specified.");
        }
        if (this.asaiVar.length() != 0) {
            IVariableField asaiField = mySession.getVariableField(new VariableName(this.asaiVar));
            value = asaiField.getStringValue();
            if (value.length() > 96) {
                mySession.throwRTException("Application data cannot be more than 96 characters");
            }
            if (result.startsWith("PD,00")) {
                savedFA = result.substring(5);
                result = "PD,04;C8," + PrepareAAI.stringToHex(asaiField.getStringValue()) + savedFA;
            } else {
                String[] searchFor;
                int startPos = 5;
                int endPos = result.length();
                String replaceWith = ";C8," + PrepareAAI.stringToHex(asaiField.getStringValue());
                StringBuilder sb = new StringBuilder(result);
                for (String s : searchFor = new String[]{";FA,", ";F5,", ";F8,"}) {
                    int foundPos = sb.indexOf(s);
                    if (foundPos <= -1) continue;
                    endPos = foundPos;
                    break;
                }
                if (startPos == endPos) {
                    sb.insert(startPos, replaceWith);
                } else {
                    sb.replace(startPos, endPos, replaceWith);
                }
                result = sb.toString();
            }
        }
        if (this.collDigitsVar.length() != 0) {
            IVariableField collDigitsField = mySession.getVariableField(new VariableName(this.collDigitsVar));
            value = collDigitsField.getStringValue();
            if (value.length() > 16) {
                mySession.throwRTException("Collected Digits cannot be more than 16 digits");
            }
            if (result.startsWith("PD,00")) {
                savedFA = result.substring(5);
                result = "PD,04" + savedFA + ";F8," + PrepareAAI.convertDigitsToPackedBinaryCodedDecimal(value);
            } else {
                String replaceWith = ";F8," + PrepareAAI.convertDigitsToPackedBinaryCodedDecimal(value);
                StringBuilder sb = new StringBuilder(result);
                int startPos = sb.indexOf(";F8,");
                if (startPos == -1) {
                    sb.append(replaceWith);
                } else {
                    sb.replace(startPos, sb.length(), replaceWith);
                }
                result = sb.toString();
            }
        }
        IVariableField resultField = mySession.getVariableField(new VariableName(this.resultVar));
        resultField.setValue(result);
    }
}

