/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.AppDocument;
import com.avaya.sce.runtime.Choice;
import com.avaya.sce.runtime.Event;
import com.avaya.sce.runtime.IOutputGenerator;
import com.avaya.sce.runtime.IRuntimeGrammar;
import com.avaya.sce.runtime.IRuntimePrompt;
import com.avaya.sce.runtime.OnDisconnect;
import com.avaya.sce.runtime.Prompt;
import com.avaya.sce.runtime.PromptRefInfo;
import com.avaya.sce.runtime.PropertiesGen;
import com.avaya.sce.runtime.Submit;
import com.avaya.sce.runtime.html.genmodel.ChoiceInput;
import com.avaya.sce.runtime.html.genmodel.MenuChoiceInput;
import com.avaya.sce.runtime.html.genmodel.TextDisplay;
import com.avaya.sce.runtime.internal.PromptFinder;
import com.avaya.sce.runtime.perf.Performance;
import com.avaya.sce.runtime.tracking.Trackable;
import com.avaya.sce.runtimecommon.SCESession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.ServletException;

public class Menu
extends AppDocument {
    private String accept = null;
    private boolean recordUtterance;
    private boolean collectMark;
    private String recognitionTarget;

    public Menu() {
        this.setRecordUtterance(false);
        this.setCollectMark(false);
    }

    public Collection getTrackingActions(SCESession mySession) {
        return null;
    }

    public Collection getPrompts(SCESession mySession) {
        return null;
    }

    public Collection getChoices(SCESession mySession) {
        return null;
    }

    public void updateChoices(Collection choices, SCESession mySession) {
    }

    public void updatePrompts(Collection prompts, SCESession mySession) {
    }

    @Override
    void prepareRendering(SCESession mySession) {
        Collection choices = this.getChoices(mySession);
        if (choices == null) {
            choices = Collections.EMPTY_LIST;
        }
        this.updateChoices(choices, mySession);
        mySession.getRequest().setAttribute("session", (Object)mySession);
        mySession.getRequest().setAttribute("choices", (Object)choices);
        ArrayList<String> promptNames = new ArrayList<String>();
        Collection prompts = this.getPrompts(mySession);
        if (prompts != null) {
            for (Object promptInfo : prompts) {
                if (promptInfo instanceof String) {
                    promptNames.add((String)promptInfo);
                    continue;
                }
                promptNames.add(((PromptRefInfo)promptInfo).getName());
            }
        }
        mySession.getRequest().setAttribute("prompts", (Object)promptNames.toArray(new String[0]));
        this.performTracking(mySession);
    }

    private void performTracking(SCESession mySession) {
        Collection trackingActions = this.getTrackingActions(mySession);
        if (trackingActions != null) {
            for (Object item : trackingActions) {
                if (item instanceof Trackable) {
                    Trackable trackable = (Trackable)((Object)item);
                    trackable.trackItems(mySession);
                    continue;
                }
                mySession.throwRTException("Invalid Tracking item in Form " + ((Object)((Object)this)).getClass().getName());
            }
        }
    }

    @Override
    void handleRequest(IOutputGenerator generator, SCESession mySession) throws ServletException, IOException {
        long stop;
        long start;
        Collection promptNames;
        ArrayList<IRuntimePrompt> prompts = new ArrayList<IRuntimePrompt>();
        if (this.isRecordUtterance()) {
            mySession.setProperty("___sagerecordutterancenameinfo", (Object)this.getName());
        }
        if ((promptNames = this.getPrompts(mySession)) != null) {
            for (Object promptInfo : promptNames) {
                String promptName = "";
                String language = "";
                if (promptInfo instanceof String) {
                    promptName = (String)promptInfo;
                } else {
                    promptName = ((PromptRefInfo)promptInfo).getName();
                    language = ((PromptRefInfo)promptInfo).getLanguage();
                }
                IRuntimePrompt prompt = PromptFinder.load(promptName, language, generator.getMySession());
                prompts.add(prompt);
                start = System.currentTimeMillis();
                prompt.updatePrompt(mySession);
                stop = System.currentTimeMillis();
                Performance.update("_avaya-update-prompt|Update Prompt", stop - start, mySession.getServlet().getServletName());
                Prompt p = (Prompt)prompt;
                p.setFormPrompt(false);
            }
        }
        start = System.currentTimeMillis();
        this.updatePrompts(prompts, mySession);
        stop = System.currentTimeMillis();
        Performance.update("_avaya-update-prompt|Update Prompt", stop - start, mySession.getServlet().getServletName());
        Collection choices = this.getChoices(mySession);
        if (choices == null) {
            choices = Collections.EMPTY_LIST;
        }
        start = System.currentTimeMillis();
        this.updateChoices(choices, mySession);
        stop = System.currentTimeMillis();
        Performance.update("_avaya-update-choice|Update Choice", stop - start, mySession.getServlet().getServletName());
        int id = 0;
        for (Choice choice : choices) {
            choice.setId(id);
            ++id;
            choice.loadGrammar(mySession);
        }
        generator.menuBegin(this, prompts, choices);
        Collection properties = this.getProperties(mySession);
        start = System.currentTimeMillis();
        this.updateProperties(properties, mySession);
        stop = System.currentTimeMillis();
        Performance.update("_avaya-update-props|Update Props", stop - start, mySession.getServlet().getServletName());
        PropertiesGen pg = new PropertiesGen(generator, properties);
        pg.generate();
        for (int i = 0; i < prompts.size(); ++i) {
            Prompt prompt = (Prompt)prompts.get(i);
            prompt.generate(generator);
        }
        for (Choice choice : choices) {
            if (!choice.isEnabled()) continue;
            choice.generate(generator);
        }
        Collection events = (Collection)mySession.getProperty("dd.appdoc.completedevents");
        if (events != null) {
            Event.updateForThresholdOne(events, generator.getMySession());
            for (Event event : events) {
                if (event instanceof OnDisconnect) {
                    OnDisconnect disconnectEvent = (OnDisconnect)event;
                    Submit submit = new Submit(disconnectEvent.getNext());
                    submit.setSubmitName(this.name);
                    disconnectEvent.setSubmitObject(submit);
                }
                event.generate(generator);
            }
        }
        generator.menuEnd(this, choices, pg);
        this.accept = null;
        this.performTracking(mySession);
        if (choices != null) {
            for (Choice choice : choices) {
                if (!choice.isEnabled()) continue;
                choice.cleanup();
            }
            choices.clear();
        }
    }

    public final void setAccept(String accept) {
        this.accept = accept;
    }

    public final String getAccept() {
        return this.accept;
    }

    public final ArrayList<String> getColumns(Collection choices) {
        ArrayList<String> cols = new ArrayList<String>();
        HashMap<String, String> uniqueCols = new HashMap<String, String>();
        for (Choice choice : choices) {
            if (!choice.isEnabled()) continue;
            Collection<String> names = choice.getUniqueColNames();
            for (String name : names) {
                uniqueCols.put(name, name);
            }
        }
        cols.addAll(uniqueCols.values());
        return cols;
    }

    public final ArrayList<IRuntimeGrammar> getGrammars(Collection choices) {
        ArrayList<IRuntimeGrammar> grammars = new ArrayList<IRuntimeGrammar>();
        for (Choice choice : choices) {
            if (!choice.isEnabled()) continue;
            Collection<IRuntimeGrammar> choiceGrammars = choice.getGrammars();
            grammars.addAll(choiceGrammars);
        }
        return grammars;
    }

    public boolean isRecordUtterance() {
        return this.recordUtterance;
    }

    public void setRecordUtterance(boolean recordUtterance) {
        this.recordUtterance = recordUtterance;
    }

    public boolean isCollectMark() {
        return this.collectMark;
    }

    public void setCollectMark(boolean collectMark) {
        this.collectMark = collectMark;
    }

    public void setRecognitionTarget(String recognitionTarget) {
        this.recognitionTarget = recognitionTarget;
    }

    public String getRecognitionTarget() {
        return this.recognitionTarget;
    }

    @Override
    public String getJsonData(SCESession mySession) {
        String prefix;
        StringBuffer jsonData = new StringBuffer("{\"uidata\": {\"sessionid\":\"");
        jsonData.append(mySession.getSessionId()).append("\",");
        jsonData.append("\"action\":\"post\",");
        jsonData.append("\"enctype\":\"multipart/form-data\",");
        String last = (String)mySession.getProperty("___OD_parameter_web_page_last");
        jsonData.append("\"previous\":\"" + last);
        String[] prompts = (String[])mySession.getRequest().getAttribute("prompts");
        Collection choices = this.getChoices(mySession);
        jsonData.append("\"");
        if (prompts != null) {
            jsonData.append(",");
            jsonData.append("\"prompts\":[");
            prefix = "";
            for (String promptName : prompts) {
                jsonData.append(prefix);
                prefix = ",";
                jsonData.append(TextDisplay.toJsonString(mySession, promptName));
            }
        }
        jsonData.append("]");
        if (choices != null) {
            jsonData.append(",");
            jsonData.append("\"links\":[");
            prefix = "";
            for (Object choice : choices) {
                MenuChoiceInput menuChoice = (MenuChoiceInput)choice;
                String choiceName = menuChoice.getChoiceType() == ChoiceInput.ChoiceType.TEXTSET ? menuChoice.getChoicesTextset() : menuChoice.getChoicesVariable();
                String next = menuChoice.getNext() + "?___DDSESSIONID=" + mySession.getSessionId();
                String icon = menuChoice.getIcon();
                String descName = menuChoice.getDescription();
                String name = MenuChoiceInput.getChoice(choiceName, menuChoice.getChoiceType(), mySession);
                String desc = MenuChoiceInput.getDescriptionTextset(descName, mySession);
                jsonData.append(prefix);
                prefix = ",";
                jsonData.append("{\"name\":\"").append(name).append("\",");
                jsonData.append("\"link\":\"").append(next).append("\",");
                jsonData.append("\"description\":\"").append(desc).append("\",");
                jsonData.append("\"icon\":\"").append(icon).append("\"}");
            }
            jsonData.append("]");
        }
        jsonData.append("}}");
        return jsonData.toString();
    }
}

