/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.LoggerUtil;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;

public class Message {
    SCESession mySession;

    public void setSession(SCESession session) {
        this.mySession = session;
    }

    StringBuilder fillInMessageBodyVariables(StringBuilder messageText) {
        int end = messageText.lastIndexOf("}_");
        while (end > -1) {
            int start = messageText.lastIndexOf("_{", end);
            if (start > 0 && messageText.charAt(start - 1) == '\\') {
                messageText.replace(start - 1, start, "");
                start = -1;
            }
            if (start == -1) break;
            String var = messageText.substring(start + 2, end);
            LoggerUtil.writeTrace((IRuntimeSession)this.mySession, (int)1, (String)("Replacing variable [" + var + "] with its value in the message body."));
            String varValue = this.getVarValue(var);
            if (varValue == null) {
                LoggerUtil.writeTrace((IRuntimeSession)this.mySession, (int)3, (String)("Unable to get variable [" + var + "] value.  Body may be incomplete."));
            } else {
                messageText.replace(start, end + 2, varValue);
            }
            end = messageText.lastIndexOf("}_", start - 1);
        }
        return messageText;
    }

    private String getVarValue(String varName) {
        if (varName == null || varName.length() == 0) {
            return null;
        }
        IVariableField field = this.mySession.getVariableField(new VariableName(varName));
        if (field != null) {
            return field.getStringValue();
        }
        return null;
    }
}

