/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.varoperations;

import com.avaya.sce.runtime.varoperations.AssignmentOperation;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.VariableName;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class SetDateTime
extends AssignmentOperation {
    private String destName;
    private String dateName;
    private String timeName;

    public SetDateTime(String destName, String dateName, String timeName) {
        this.destName = destName;
        this.dateName = dateName;
        this.timeName = timeName;
    }

    @Override
    public void evaluate(IRuntimeSession mySession) {
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(2, "Setting Datetime to [" + this.destName + "]");
        }
        IVariable dateVar = null;
        IVariable timeVar = null;
        if (this.dateName != null) {
            dateVar = mySession.getVariable(this.dateName);
        }
        if (this.timeName != null) {
            timeVar = mySession.getVariable(this.timeName);
        }
        Calendar calendar = Calendar.getInstance(Locale.US);
        int day = calendar.get(5);
        int month = calendar.get(2) + 1;
        int year = calendar.get(1);
        if (dateVar != null) {
            year = this.getIntValue(dateVar.getComplexVariable().getField("year"));
            IVariableField monthField = dateVar.getComplexVariable().getField("monthinyear");
            if (monthField == null) {
                monthField = dateVar.getComplexVariable().getField("month");
            }
            month = this.getIntValue(monthField);
            IVariableField dayField = dateVar.getComplexVariable().getField("day");
            if (dayField == null) {
                dayField = dateVar.getComplexVariable().getField("dayofmonth");
            }
            day = this.getIntValue(dayField);
        }
        int hour = 0;
        int minute = 0;
        int second = 0;
        int millisec = 0;
        if (timeVar != null) {
            hour = this.getIntValue(timeVar.getComplexVariable().getField("hour"));
            minute = this.getIntValue(timeVar.getComplexVariable().getField("minute"));
            second = this.getIntValue(timeVar.getComplexVariable().getField("second"));
            millisec = this.getIntValue(timeVar.getComplexVariable().getField("millisecond"));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd kk:mm:ss.S");
        StringBuffer sb = new StringBuffer();
        sb.append(year).append("/").append(month).append("/").append(day);
        sb.append(" ");
        sb.append(hour).append(":").append(minute).append(":").append(second).append(".").append(millisec);
        Date date = null;
        try {
            date = sdf.parse(sb.toString());
        }
        catch (Exception e) {
            mySession.getTraceOutput().writeln(4, "Error parsing datetime input - " + sb);
        }
        IVariableField field = mySession.getVariableField(new VariableName(this.destName));
        field.setValue((Object)date);
        DateFormat df = DateFormat.getInstance();
        String dateString = null;
        if (date != null) {
            dateString = df.format(date);
        }
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(2, "Datetime " + dateString + " got set.");
        }
    }

    private int getIntValue(IVariableField field) {
        if (field == null) {
            return 0;
        }
        String valueStr = field.getStringValue();
        int value = valueStr.equals("__DD_NULL") ? 0 : field.getIntValue();
        return value;
    }
}

