/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.cs.pdc.service;

import com.avaya.cs.pdc.Config;
import com.avaya.cs.pdc.OperationType;
import com.avaya.cs.pdc.service.AbstractSimulatorOperation;
import com.avaya.cs.pdc.service.ContextStoreOperation;
import com.avaya.cs.pdc.service.DeleteAliasIdSimulatorOperation;
import com.avaya.cs.pdc.service.DeleteContextByAliasIdSimulatorOperation;
import com.avaya.cs.pdc.service.DeleteContextSimulatorOperation;
import com.avaya.cs.pdc.service.DeleteValueByAliasIdSimulatorOperation;
import com.avaya.cs.pdc.service.DeleteValueSimulatorOperation;
import com.avaya.cs.pdc.service.GetAuditDataByAliasIdSimulatorOperation;
import com.avaya.cs.pdc.service.GetAuditDataSimulatorOperation;
import com.avaya.cs.pdc.service.GetContextIdsSimulatorOperation;
import com.avaya.cs.pdc.service.GetDataByAliasIdSimulatorOperation;
import com.avaya.cs.pdc.service.GetDataSimulatorOperation;
import com.avaya.cs.pdc.service.GetValueByAliasIdSimulatorOperation;
import com.avaya.cs.pdc.service.GetValueSimulatorOperation;
import com.avaya.cs.pdc.service.PostContextSimulatorOperation;
import com.avaya.cs.pdc.service.PostContextWithAliasIdSimulatorOperation;
import com.avaya.cs.pdc.service.PutAliasIdByAliasIdSimulatorOperation;
import com.avaya.cs.pdc.service.PutAliasIdSimulatorOperation;
import com.avaya.cs.pdc.service.PutDataByAliasIdSimulatorOperation;
import com.avaya.cs.pdc.service.PutDataSimulatorOperation;
import com.avaya.cs.pdc.service.PutValueByAliasIdSimulatorOperation;
import com.avaya.cs.pdc.service.PutValueSimulatorOperation;
import com.avaya.cs.pdc.service.UpsertContextByAliasIdSimulatorOperation;
import com.avaya.cs.pdc.service.UpsertContextSimulatorOperation;
import java.util.HashMap;

public final class SimulatorOperationFactory {
    private SimulatorOperationFactory() {
    }

    public static ContextStoreOperation buildService(OperationType operation, Config config, String ip, String id, String rid, String key, String json, String touchpoint, String groupId) {
        OperationType opType = operation == null ? OperationType.GET_DATA : operation;
        HashMap<OperationType, AbstractSimulatorOperation> map = new HashMap<OperationType, AbstractSimulatorOperation>();
        map.put(OperationType.GET_AUDIT_DATA, new GetAuditDataSimulatorOperation(config, ip, id, rid, touchpoint));
        map.put(OperationType.GET_AUDIT_DATA_BY_ALIASID, new GetAuditDataByAliasIdSimulatorOperation(config, ip, id, rid, touchpoint));
        map.put(OperationType.GET_DATA, new GetDataSimulatorOperation(config, ip, id, rid, touchpoint));
        map.put(OperationType.GET_DATA_BY_ALIASID, new GetDataByAliasIdSimulatorOperation(config, ip, id, rid, touchpoint));
        map.put(OperationType.GET_VALUE, new GetValueSimulatorOperation(config, ip, id, rid, key, touchpoint));
        map.put(OperationType.GET_VALUE_BY_ALIASID, new GetValueByAliasIdSimulatorOperation(config, ip, id, rid, key, touchpoint));
        map.put(OperationType.GET_CONTEXT_IDS, new GetContextIdsSimulatorOperation(config, ip, id, rid, key, json, touchpoint, groupId));
        map.put(OperationType.PUT_DATA, new PutDataSimulatorOperation(config, ip, id, rid, json, touchpoint, groupId));
        map.put(OperationType.PUT_DATA_BY_ALIASID, new PutDataByAliasIdSimulatorOperation(config, ip, id, rid, json, touchpoint, groupId));
        map.put(OperationType.PUT_VALUE, new PutValueSimulatorOperation(config, ip, id, rid, key, json, touchpoint));
        map.put(OperationType.PUT_VALUE_BY_ALIASID, new PutValueByAliasIdSimulatorOperation(config, ip, id, rid, key, json, touchpoint));
        map.put(OperationType.PUT_ALIASID, new PutAliasIdSimulatorOperation(config, ip, id, rid, json, touchpoint));
        map.put(OperationType.PUT_ALIASID_BY_ALIASID, new PutAliasIdByAliasIdSimulatorOperation(config, ip, id, rid, json, touchpoint));
        map.put(OperationType.UPSERT_CONTEXT, new UpsertContextSimulatorOperation(config, ip, id, rid, json, touchpoint));
        map.put(OperationType.UPSERT_CONTEXT_BY_ALIASID, new UpsertContextByAliasIdSimulatorOperation(config, ip, id, rid, json, touchpoint));
        map.put(OperationType.POST_CONTEXT, new PostContextSimulatorOperation(config, ip, id, rid, json, touchpoint));
        map.put(OperationType.POST_CONTEXT_WITH_ALIASID, new PostContextWithAliasIdSimulatorOperation(config, ip, id, rid, json, touchpoint));
        map.put(OperationType.DELETE_CONTEXT, new DeleteContextSimulatorOperation(config, ip, id, rid));
        map.put(OperationType.DELETE_CONTEXT_BY_ALIASID, new DeleteContextByAliasIdSimulatorOperation(config, ip, id, rid));
        map.put(OperationType.DELETE_VALUE, new DeleteValueSimulatorOperation(config, ip, id, rid, key, touchpoint));
        map.put(OperationType.DELETE_VALUE_BY_ALIASID, new DeleteValueByAliasIdSimulatorOperation(config, ip, id, rid, key, touchpoint));
        map.put(OperationType.DELETE_ALIASID, new DeleteAliasIdSimulatorOperation(config, ip, id, rid, touchpoint));
        return (ContextStoreOperation)map.get((Object)opType);
    }
}

