/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.cs.pdc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Config {
    private static final int SIMULATION_INDEX = 0;
    private static final int URL_INDEX = 1;
    private static final int STRATEGY_INDEX = 2;
    private static final int USER_INDEX = 3;
    private static final int PASSWORD_INDEX = 4;
    private static final int TIMEOUT_INDEX = 5;
    private static final int LEASE_TIME_INDEX = 6;
    private static final int RETRIES_INDEX = 7;
    private static final int GEO_URL_INDEX = 8;
    private static final int SHORTID_INDEX = 9;
    private static final int CONFIG_LENGTH = 10;
    private static final int KEY_VALUE_ARRAY_LENGTH = 2;
    private static final String HASH = "#";
    private List<String> url;
    private List<String> geoUrl;
    private String strategy;
    private String user;
    private String password;
    private String timeout;
    private String leaseTime;
    private boolean generateShortId;
    private String retries = "1";
    private boolean geoUrlsInUse = false;
    private boolean simulation;
    private final boolean configured;
    public static final Config EMPTY_CONFIG = new Config(null);

    public Config(List<String> url, String strategy, String user, String password, String timeout, String leaseTime, boolean simulation, boolean generateShortId) {
        this.url = url;
        this.strategy = strategy;
        this.user = user;
        this.password = password;
        this.timeout = timeout;
        this.leaseTime = leaseTime;
        this.simulation = simulation;
        this.configured = true;
        this.generateShortId = generateShortId;
    }

    public Config(List<String> url, String strategy, String user, String password, String timeout, String leaseTime, String retries, boolean simulation, boolean generateShortId, List<String> geoUrl) {
        this.url = url;
        this.strategy = strategy;
        this.user = user;
        this.password = password;
        this.timeout = timeout;
        this.leaseTime = leaseTime;
        this.retries = retries;
        this.simulation = simulation;
        this.configured = true;
        this.geoUrl = geoUrl;
        this.generateShortId = generateShortId;
    }

    public Config(String config) {
        boolean testConfigured = config != null;
        String[] splitConfig = null;
        if (testConfigured) {
            splitConfig = config.split(HASH);
            testConfigured = splitConfig.length == 10;
        }
        this.configured = testConfigured;
        this.setConfig(splitConfig);
    }

    private void setConfig(String[] splitConfig) {
        this.setBooleanConfigs(splitConfig);
        this.url = this.configured ? this.getValueList(splitConfig[1]) : new ArrayList<String>();
        this.strategy = this.configured ? this.getValue(splitConfig[2]) : "";
        this.user = this.configured ? this.getValue(splitConfig[3]) : "";
        this.password = this.configured ? this.getValue(splitConfig[4]) : "";
        this.timeout = this.configured ? this.getValue(splitConfig[5]) : "";
        this.leaseTime = this.configured ? this.getValue(splitConfig[6]) : "";
        this.retries = this.configured ? this.getValue(splitConfig[7]) : "";
        this.geoUrl = this.configured ? this.getValueList(splitConfig[8]) : new ArrayList<String>();
    }

    private void setBooleanConfigs(String[] splitConfig) {
        this.simulation = this.configured ? Boolean.valueOf(this.getValue(splitConfig[0])) : false;
        this.generateShortId = this.configured ? Boolean.valueOf(this.getValue(splitConfig[9])) : false;
    }

    private String getValue(String keyValue) {
        String[] split = keyValue.split("=");
        if (split.length == 2) {
            return split[1];
        }
        return "";
    }

    private List<String> getValueList(String keyValue) {
        String[] split = keyValue.split("=");
        if (split.length == 2) {
            String[] splitList = split[1].split("\\|");
            return Arrays.asList(splitList);
        }
        return new ArrayList<String>();
    }

    public List<String> getUrl() {
        return this.url;
    }

    public String getStrategy() {
        return this.strategy;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public String getLeaseTime() {
        return this.leaseTime;
    }

    public String getRetries() {
        return this.retries;
    }

    public boolean isSimulation() {
        return this.simulation;
    }

    public boolean isShortIdGeneration() {
        return this.generateShortId;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public List<String> getGeoUrl() {
        return this.geoUrl;
    }

    public boolean isGeoUrlsInUse() {
        return this.geoUrlsInUse;
    }

    public void setGeoUrlsInUse(boolean geoUrlsInUse) {
        this.geoUrlsInUse = geoUrlsInUse;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("isSimulation=").append(this.simulation ? "true" : "false").append(HASH);
        result.append("url=").append(StringUtils.join(this.url, (String)"|")).append(HASH);
        result.append("strategy=").append(StringUtils.defaultString((String)this.strategy)).append(HASH);
        result.append("user=").append(StringUtils.defaultString((String)this.user)).append(HASH);
        result.append("password=").append(StringUtils.defaultString((String)this.password)).append(HASH);
        result.append("timeout=").append(StringUtils.defaultString((String)this.timeout)).append(HASH);
        result.append("leaseTime=").append(StringUtils.defaultString((String)this.leaseTime)).append(HASH);
        result.append("retries=").append(StringUtils.defaultString((String)this.retries)).append(HASH);
        result.append("geoUrl=").append(StringUtils.join(this.geoUrl, (String)"|")).append(HASH);
        result.append("generateShortId=").append(this.generateShortId ? "true" : "false");
        return result.toString();
    }
}

