/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.cs.pdc.service.connectionpooling;

import com.avaya.cs.pdc.Config;
import com.avaya.cs.pdc.util.SystemOutLogging;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public final class HttpClientFactory {
    private static final SystemOutLogging LOG = new SystemOutLogging();
    private static final int POOLING_CONNECTION_NUMBER = 10;
    private static volatile PoolingHttpClientConnectionManager connManager;

    private HttpClientFactory() {
    }

    public static synchronized HttpClient getHttpClientInstance(Config config) {
        if (config.getUrl().get(0).contains("https")) {
            return HttpClientFactory.createHttpsConnection();
        }
        return HttpClientFactory.createHttpConnection();
    }

    public static synchronized void closeHttpClientInstance() {
        connManager.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpClient createHttpsConnection() {
        SSLContext sslcontext;
        KeyStore ks1;
        String keyStoreLocation = System.getProperty("javax.net.ssl.trustStore", "");
        String keyStorePassword = System.getProperty("javax.net.ssl.trustStorePassword", "");
        try {
            ks1 = KeyStore.getInstance("JKS");
        }
        catch (KeyStoreException e) {
            LOG.error("HttpClientFactory.createHttpsConnection() Exception Occurred Getting KeyStore Instance: " + e);
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(keyStoreLocation);
            ks1.load(fileInputStream, keyStorePassword.toCharArray());
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            LOG.error("HttpClientFactory.createHttpsConnection() Exception Occurred Reading Key: " + e);
            HttpClient httpClient = null;
            return httpClient;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    LOG.error("HttpClientFactory.createHttpsConnection() IOException Occurred: " + e);
                }
            }
        }
        try {
            sslcontext = SSLContexts.custom().loadKeyMaterial(ks1, keyStorePassword.toCharArray()).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            LOG.error("HttpClientFactory.createHttpsConnection() Exception Occurred Building SSL Context: " + e);
            return null;
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).build();
        connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connManager.setMaxTotal(10);
        connManager.setDefaultMaxPerRoute(10);
        connManager.setDefaultSocketConfig(HttpClientFactory.getSocketConfig());
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
    }

    private static HttpClient createHttpConnection() {
        connManager = new PoolingHttpClientConnectionManager();
        connManager.setMaxTotal(10);
        connManager.setDefaultMaxPerRoute(10);
        connManager.setDefaultSocketConfig(HttpClientFactory.getSocketConfig());
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
    }

    private static SocketConfig getSocketConfig() {
        return SocketConfig.custom().setTcpNoDelay(true).setSoKeepAlive(true).setSoReuseAddress(true).build();
    }
}

