/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.cs.pdc;

import com.avaya.cs.pdc.Config;
import com.avaya.cs.pdc.OperationType;
import com.avaya.cs.pdc.service.ContextStoreOperation;
import com.avaya.cs.pdc.service.OperationFactory;
import com.avaya.cs.pdc.service.Response;
import com.avaya.cs.pdc.util.Logger;
import com.avaya.sce.runtime.IPluggableExecutable;
import com.avaya.sce.runtimecommon.Debugging;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class PdcExecutable
extends Debugging
implements IPluggableExecutable {
    private static final String QUOTE = "\"";
    private static final String QUOTE_LF = "\"\n";
    private final String inVariable;
    private final String inIPField;
    private final String inIdField;
    private final String inRidField;
    private final String inKeyField;
    private final String inJsonField;
    private final String inTpField;
    private final String inGroupIdField;
    private final String inOperation;
    private final String outVariable;
    private final String outDataField;
    private final String outStatusField;
    private final String outMessageField;
    private static final String CONTEXT_PARAM_KEY_CS_CONNECTOR_PDC_GEO = "avaya.cs.connector.pdc.geoenabled";
    private static AtomicBoolean isGeoEnabledInPropertiesFile = null;
    private static AtomicReference<Config> config = new AtomicReference();

    public PdcExecutable(String inVariable, String inIPField, String inIdField, String inRidField, String inKeyField, String inJsonField, String inTpField, String inGroupIdField, String inOperation, String outVariable, String outDataField, String outStatusField, String outMessageField) {
        this.inVariable = inVariable;
        this.inIPField = inIPField;
        this.inIdField = inIdField;
        this.inRidField = inRidField;
        this.inKeyField = inKeyField;
        this.inJsonField = inJsonField;
        this.inTpField = inTpField;
        this.inGroupIdField = inGroupIdField;
        this.inOperation = inOperation;
        this.outVariable = outVariable;
        this.outDataField = outDataField;
        this.outStatusField = outStatusField;
        this.outMessageField = outMessageField;
    }

    public void execute(IRuntimeSession session) {
        this.getAndSetPropertiesFromWebXml(session);
        this.logVariables(session);
        if (config.get().isGeoUrlsInUse()) {
            this.traceDebug(session, "GeoUrls are in use");
        } else {
            this.traceDebug(session, "GeoUrls are not in use");
            if (this.executeListOfUrls(session, config.get().getUrl().size(), Integer.parseInt(config.get().getRetries()))) {
                return;
            }
            this.changeConfigIfGeoEnabledInProperties();
        }
        if (isGeoEnabledInPropertiesFile.get() && config.get().isGeoUrlsInUse()) {
            this.executeListOfUrls(session, config.get().getGeoUrl().size(), Integer.parseInt(config.get().getRetries()));
        }
    }

    private void changeConfigIfGeoEnabledInProperties() {
        if (isGeoEnabledInPropertiesFile.get()) {
            Config tempConfig = new Config(config.get().toString());
            tempConfig.setGeoUrlsInUse(true);
            config.set(tempConfig);
        }
    }

    private void getAndSetPropertiesFromWebXml(IRuntimeSession session) {
        if (config.get() == null) {
            this.buildConfig(session);
        }
        if (isGeoEnabledInPropertiesFile == null) {
            this.checkAndSetShouldGeoBeEnabled(session);
        }
    }

    private synchronized void checkAndSetShouldGeoBeEnabled(IRuntimeSession session) {
        if (this.isGeoLocationEnabled(session)) {
            this.traceDebug(session, "geo is enabled in properties file");
            isGeoEnabledInPropertiesFile = new AtomicBoolean(true);
        } else {
            isGeoEnabledInPropertiesFile = new AtomicBoolean(false);
        }
    }

    private boolean isGeoLocationEnabled(IRuntimeSession session) {
        String parameterValue = session.getParameter(CONTEXT_PARAM_KEY_CS_CONNECTOR_PDC_GEO);
        return parameterValue != null && parameterValue.equals("yes");
    }

    private boolean executeListOfUrls(IRuntimeSession session, int numberOfUrls, int numberOfRetries) {
        for (int j = 0; j < numberOfRetries + 1; ++j) {
            for (int i = 0; i < numberOfUrls; ++i) {
                this.traceDebug(session, " before get service");
                ContextStoreOperation service = this.getService(session);
                this.traceDebug(session, " before execute");
                Response response = service.execute();
                this.fillResults(session, response);
                String ipVariable = this.getComplexVariable(session, this.inVariable, this.inIPField);
                if (ipVariable != null && ipVariable.length() != 0) {
                    String url = config.get().getUrl().toString();
                    int position = url.indexOf(58);
                    String protocol = url.substring(0, position).concat("://");
                    this.traceDebug(session, " Response code of '" + response.getStatus().toString() + "' received for retry attempt #" + j + " @ url number " + i + ", " + protocol + ipVariable + "/services/CSRest/cs]");
                    Logger.info(session, " Result of '" + this.inOperation + "' operation to " + protocol + ipVariable + "/services/CSRest/cs : status = '" + response.getStatus() + "', message = '" + response.getMessage() + "'");
                } else {
                    this.traceDebug(session, " Response code of '" + response.getStatus().toString() + "' received for retry attempt #" + j + " @ url number " + i + " " + config.get().getUrl());
                    Logger.info(session, " Result of '" + this.inOperation + "' operation to " + config.get().getUrl() + ": status = '" + response.getStatus() + "', message = '" + response.getMessage() + "'");
                }
                if (response.getStatus() != 408) {
                    return true;
                }
                this.traceDebug(session, "try " + i + " failed ");
            }
        }
        return false;
    }

    private Config buildConfig(IRuntimeSession session) {
        if (config.get() == null) {
            this.traceDebug(session, "Build the config variable to get some additional parameters.");
            config.set(new Config(session.getParameter("avaya.cs.connector.config")));
            this.traceDebug(session, "Context Store PDC Configuration: " + config.toString());
        }
        return config.get();
    }

    private void fillResults(IRuntimeSession session, Response response) {
        this.traceDebug(session, "Build output variable that will be return to the workflow.");
        IVariable output = session.getVariable(this.outVariable);
        if (output == null) {
            Logger.error(session, "Output variable was not defined.");
        } else {
            this.setValueInField(session, output, this.outStatusField, response.getStatus(), IVariableField.VarDataType.INT, "Status");
            this.setValueInField(session, output, this.outMessageField, response.getMessage(), IVariableField.VarDataType.STRING, "Message");
            this.setValueInField(session, output, this.outDataField, response.getData(), IVariableField.VarDataType.OBJECT, "Data");
        }
    }

    private void setValueInField(IRuntimeSession session, IVariable output, String field, Object value, IVariableField.VarDataType dataType, String userFriendlyName) {
        IVariableField variableField = output.getComplexVariable().getField(field);
        IVariableField.VarDataType dType = dataType;
        if (variableField == null) {
            Logger.error(session, "Output field \"" + userFriendlyName + "\" was not defined.");
        } else {
            if (IVariableField.VarDataType.OBJECT.equals((Object)dataType) && value instanceof String) {
                dType = IVariableField.VarDataType.STRING;
            }
            variableField.setValue(value, dType);
        }
    }

    private void logVariables(IRuntimeSession session) {
        StringBuilder sb = new StringBuilder();
        sb.append("Context Store PDC Received the following variable names: \n");
        sb.append("inVariable=").append(QUOTE).append(this.inVariable).append(QUOTE_LF);
        sb.append("inIPField=").append(QUOTE).append(this.inIPField).append(QUOTE_LF);
        sb.append("inIdField=").append(QUOTE).append(this.inIdField).append(QUOTE_LF);
        sb.append("inRidField=").append(QUOTE).append(this.inRidField).append(QUOTE_LF);
        sb.append("inKeyField=").append(QUOTE).append(this.inKeyField).append(QUOTE_LF);
        sb.append("inJsonField=").append(QUOTE).append(this.inJsonField).append(QUOTE_LF);
        sb.append("inTouchpointField=").append(QUOTE).append(this.inTpField).append(QUOTE_LF);
        sb.append("inGroupIdField=").append(QUOTE).append(this.inGroupIdField).append(QUOTE_LF);
        sb.append("inOperation=").append(QUOTE).append(this.inOperation).append(QUOTE_LF);
        sb.append("outVariable=").append(QUOTE).append(this.outVariable).append(QUOTE_LF);
        sb.append("outDataField=").append(QUOTE).append(this.outDataField).append(QUOTE_LF);
        sb.append("outStatusField=").append(QUOTE).append(this.outStatusField).append(QUOTE_LF);
        sb.append("outMessageField=").append(QUOTE).append(this.outMessageField).append(QUOTE_LF);
        this.traceDebug(session, sb.toString());
    }

    private String getComplexVariable(IRuntimeSession session, String variable, String field) {
        IVariableField pdcField;
        String value = null;
        IVariable pdcVariable = session.getVariable(variable);
        if (pdcVariable != null && (pdcField = pdcVariable.getComplexVariable().getField(field)) != null) {
            value = pdcField.getStringValue();
        }
        return value;
    }

    public String getId() {
        return "com.avaya.cs.pdc";
    }

    protected ContextStoreOperation getService(IRuntimeSession session) {
        OperationType operation = OperationType.byDescription(this.inOperation);
        String ip = this.getComplexVariable(session, this.inVariable, this.inIPField);
        String id = this.getComplexVariable(session, this.inVariable, this.inIdField);
        String rid = this.getComplexVariable(session, this.inVariable, this.inRidField);
        String key = this.getComplexVariable(session, this.inVariable, this.inKeyField);
        String json = this.getComplexVariable(session, this.inVariable, this.inJsonField);
        String touchpoint = this.getComplexVariable(session, this.inVariable, this.inTpField);
        String groupId = this.getComplexVariable(session, this.inVariable, this.inGroupIdField);
        return OperationFactory.buildService(operation, this.buildConfig(session), ip, id, rid, key, json, touchpoint, groupId);
    }

    private void traceDebug(IRuntimeSession session, String message) {
        if (session.isTraceEnabled()) {
            session.getTraceOutput().writeln(1, message);
        }
    }

    public String getTraceMessage() {
        return "Get/Set values using Context Store service.";
    }
}

