/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.cs.pdc.service;

import com.avaya.cs.pdc.Config;
import com.avaya.cs.pdc.OperationType;
import com.avaya.cs.pdc.service.AbstractHttpOperation;
import com.avaya.cs.pdc.service.ContextStoreOperation;
import com.avaya.cs.pdc.service.DeleteAliasIdHttpOperation;
import com.avaya.cs.pdc.service.DeleteContextByAliasIdHttpOperation;
import com.avaya.cs.pdc.service.DeleteContextHttpOperation;
import com.avaya.cs.pdc.service.DeleteValueByAliasIdHttpOperation;
import com.avaya.cs.pdc.service.DeleteValueHttpOperation;
import com.avaya.cs.pdc.service.GetAuditDataByAliasIdHttpOperation;
import com.avaya.cs.pdc.service.GetAuditDataHttpOperation;
import com.avaya.cs.pdc.service.GetContextIdsHttpOperation;
import com.avaya.cs.pdc.service.GetDataByAliasIdHttpOperation;
import com.avaya.cs.pdc.service.GetDataHttpOperation;
import com.avaya.cs.pdc.service.GetValueByAliasIdHttpOperation;
import com.avaya.cs.pdc.service.GetValueHttpOperation;
import com.avaya.cs.pdc.service.PostContextHttpOperation;
import com.avaya.cs.pdc.service.PostContextWithAliasIdHttpOperation;
import com.avaya.cs.pdc.service.PutAliasIdByAliasIdHttpOperation;
import com.avaya.cs.pdc.service.PutAliasIdHttpOperation;
import com.avaya.cs.pdc.service.PutDataByAliasIdHttpOperation;
import com.avaya.cs.pdc.service.PutDataHttpOperation;
import com.avaya.cs.pdc.service.PutValueByAliasIdHttpOperation;
import com.avaya.cs.pdc.service.PutValueHttpOperation;
import com.avaya.cs.pdc.service.UpsertContextByAliasIdHttpOperation;
import com.avaya.cs.pdc.service.UpsertContextHttpOperation;
import java.util.HashMap;

public final class HttpOperationFactory {
    private HttpOperationFactory() {
    }

    public static ContextStoreOperation buildService(OperationType operation, Config config, String ip, String id, String rid, String key, String json, String touchpoint, String groupId) {
        OperationType opType = operation == null ? OperationType.GET_DATA : operation;
        HashMap<OperationType, AbstractHttpOperation> map = new HashMap<OperationType, AbstractHttpOperation>();
        map.put(OperationType.GET_AUDIT_DATA, new GetAuditDataHttpOperation(config, ip, id, rid, touchpoint));
        map.put(OperationType.GET_AUDIT_DATA_BY_ALIASID, new GetAuditDataByAliasIdHttpOperation(config, ip, id, rid, touchpoint));
        map.put(OperationType.GET_DATA, new GetDataHttpOperation(config, ip, id, rid, touchpoint));
        map.put(OperationType.GET_DATA_BY_ALIASID, new GetDataByAliasIdHttpOperation(config, ip, id, rid, touchpoint));
        map.put(OperationType.GET_VALUE, new GetValueHttpOperation(config, ip, id, rid, key, touchpoint));
        map.put(OperationType.GET_VALUE_BY_ALIASID, new GetValueByAliasIdHttpOperation(config, ip, id, rid, key, touchpoint));
        map.put(OperationType.GET_CONTEXT_IDS, new GetContextIdsHttpOperation(config, ip, id, rid, key, json, touchpoint, groupId));
        map.put(OperationType.PUT_DATA, new PutDataHttpOperation(config, ip, id, rid, json, touchpoint, groupId));
        map.put(OperationType.PUT_DATA_BY_ALIASID, new PutDataByAliasIdHttpOperation(config, ip, id, rid, json, touchpoint, groupId));
        map.put(OperationType.PUT_VALUE, new PutValueHttpOperation(config, ip, id, rid, key, json, touchpoint));
        map.put(OperationType.PUT_VALUE_BY_ALIASID, new PutValueByAliasIdHttpOperation(config, ip, id, rid, key, json, touchpoint));
        map.put(OperationType.PUT_ALIASID, new PutAliasIdHttpOperation(config, ip, id, rid, json, touchpoint));
        map.put(OperationType.PUT_ALIASID_BY_ALIASID, new PutAliasIdByAliasIdHttpOperation(config, ip, id, rid, json, touchpoint));
        map.put(OperationType.UPSERT_CONTEXT, new UpsertContextHttpOperation(config, ip, id, rid, json, touchpoint));
        map.put(OperationType.UPSERT_CONTEXT_BY_ALIASID, new UpsertContextByAliasIdHttpOperation(config, ip, id, rid, json, touchpoint));
        map.put(OperationType.POST_CONTEXT, new PostContextHttpOperation(config, ip, id, rid, json, touchpoint));
        map.put(OperationType.POST_CONTEXT_WITH_ALIASID, new PostContextWithAliasIdHttpOperation(config, ip, id, rid, json, touchpoint));
        map.put(OperationType.DELETE_CONTEXT, new DeleteContextHttpOperation(config, ip, id, rid));
        map.put(OperationType.DELETE_CONTEXT_BY_ALIASID, new DeleteContextByAliasIdHttpOperation(config, ip, id, rid));
        map.put(OperationType.DELETE_VALUE, new DeleteValueHttpOperation(config, ip, id, rid, key, touchpoint));
        map.put(OperationType.DELETE_VALUE_BY_ALIASID, new DeleteValueByAliasIdHttpOperation(config, ip, id, rid, key, touchpoint));
        map.put(OperationType.DELETE_ALIASID, new DeleteAliasIdHttpOperation(config, ip, id, rid, touchpoint));
        return (ContextStoreOperation)map.get((Object)opType);
    }
}

