/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.cs.pdc.service;

import com.avaya.cs.pdc.service.PickUpServerStrategy;
import com.avaya.cs.pdc.service.RandomStrategy;
import com.avaya.cs.pdc.service.RoundRobinStrategy;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class PickUpServerStrategyFactory {
    private static Map<String, PickUpServerStrategy<String>> strategies = new HashMap<String, PickUpServerStrategy<String>>();
    private static final String RANDOM = "Random";
    private static final String ROUND_ROBIN = "RoundRobin";
    private static final String DEFAULT_STRATEGY = "RoundRobin";

    private PickUpServerStrategyFactory() {
    }

    public static PickUpServerStrategy<String> getStrategy(String s) {
        return StringUtils.isEmpty((CharSequence)s) || !strategies.containsKey(s) ? strategies.get("RoundRobin") : strategies.get(s);
    }

    static {
        strategies.put("RoundRobin", new RoundRobinStrategy());
        strategies.put(RANDOM, new RandomStrategy());
    }
}

