/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.cs.pdc.service;

import com.avaya.cs.pdc.Config;
import com.avaya.cs.pdc.service.AbstractHttpOperation;
import com.avaya.cs.pdc.service.Response;
import com.avaya.cs.pdc.util.Pair;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;

public class PostContextHttpOperation
extends AbstractHttpOperation {
    private static final String CONTEXTID = "contextId";
    private static final String DATA = "data";

    public PostContextHttpOperation(Config config, String ip, String id, String rid, String json, String touchpoint) {
        super(config, ip, id, rid, (String)null, json, touchpoint, (String)null, (Boolean)false);
    }

    @Override
    public HttpRequestBase prepareHttpUriRequest() throws UnsupportedEncodingException {
        HttpPost request = new HttpPost(this.applyValidVariableIP(this.getIp()) + "/contexts/");
        request.setEntity((HttpEntity)new StringEntity(this.getJson(), "UTF-8"));
        request.setHeader("Accept", "application/json");
        request.setHeader("Content-type", "application/json");
        return request;
    }

    @Override
    public Pair<Boolean, List<String>> validate() {
        Pair<Boolean, List<String>> pair = this.composeValidation(null, this.isValidConfig());
        pair = this.composeValidation(pair, this.isValidJson());
        return pair;
    }

    @Override
    Response treatResponse(Response response) throws IOException {
        if (response.getStatus() == 200) {
            String returnedData = (String)response.getData();
            if (StringUtils.isNotBlank((CharSequence)returnedData)) {
                HashMap innerNode;
                Map node = (Map)PostContextHttpOperation.getMapper().readValue((String)response.getData(), Map.class);
                String contextId = "";
                if (node.containsKey(DATA) && (innerNode = (HashMap)node.get(DATA)).containsKey(CONTEXTID)) {
                    contextId = (String)innerNode.get(CONTEXTID);
                }
                return new Response(response.getStatus(), response.getMessage(), contextId);
            }
            return response;
        }
        return response;
    }
}

