/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ingensg.ce.wa.imrest.common.model;

import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ServiceMetrics {
    @ApiModelProperty(value="Map of service attributes used to match against", required=true, notes="min = 1, max = 10")
    @NotNull(message="The attribute map cannot be null")
    private Map<String, List<String>> attributes;
    @ApiModelProperty(value="The priority of this Service request", required=true, notes="any value from 1-10, or not specified. 1 meaning a high priority 10 meaning a low priority")
    @Min(value=0L, message="The minimum value for priority is {value}")
    @Max(value=10L, message="The maximum value for priority is {value}")
    private Integer priority;

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static final class ValuesBuilder {
        private final Builder builder;
        private String category;

        private ValuesBuilder(Builder builder) {
            this.builder = builder;
        }

        void setCategory(String category) {
            this.category = category;
        }

        public Builder withValues(String ... values) {
            List<String> vals = this.builder.serviceMetrics.getAttributes().get(this.category);
            vals.addAll(Arrays.asList(values));
            this.builder.serviceMetrics.getAttributes().put(this.category, vals);
            return this.builder;
        }
    }

    public static class Builder {
        private final ValuesBuilder vBuilder = new ValuesBuilder(this);
        private final ServiceMetrics serviceMetrics = new ServiceMetrics();

        public Builder priority(Integer priority) {
            this.serviceMetrics.setPriority(priority);
            return this;
        }

        public ValuesBuilder addAttributeCategory(String category) {
            List<String> vals;
            Map<String, List<String>> atts = this.serviceMetrics.getAttributes();
            if (atts == null) {
                atts = new HashMap<String, List<String>>();
            }
            if ((vals = atts.get(category)) == null) {
                vals = new ArrayList<String>();
            }
            atts.put(category, vals);
            this.serviceMetrics.setAttributes(atts);
            this.vBuilder.setCategory(category);
            return this.vBuilder;
        }

        public ServiceMetrics build() {
            return this.serviceMetrics;
        }
    }
}

