/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints;

import com.avaya.ingensg.ce.wa.imrest.common.model.MatchRequestAsync;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidCallbackURL;
import com.avaya.ucam.common.logger.api.EmLogger;
import com.avaya.ucam.common.logger.factory.EmLoggerFactoryImpl;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class ValidCallbackURLValidator
implements ConstraintValidator<ValidCallbackURL, MatchRequestAsync> {
    private static final EmLogger LOG = EmLoggerFactoryImpl.INSTANCE.getLogger(ValidCallbackURLValidator.class);

    public void initialize(ValidCallbackURL constraintAnnotation) {
    }

    public boolean isValid(MatchRequestAsync matchRequestAsync, ConstraintValidatorContext context) {
        String methodName = "isValid";
        if (null == matchRequestAsync) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        Boolean valid = true;
        String callbackMechanism = matchRequestAsync.getCallbackMechanism();
        if (callbackMechanism == null) {
            valid = false;
            LOG.error("isValid", "", "Callback URL mechanism cannot be null", new Object[0]);
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidCallbackURL.mechanism}").addConstraintViolation();
        } else if (callbackMechanism.equals("EventingFramework")) {
            if (matchRequestAsync.getCorrelationId() == null) {
                valid = false;
                LOG.error("isValid", "", "For EventingFramework callback mechanism URL should contains valid CorrelationId", new Object[0]);
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidCallbackURL.correlationId}").addConstraintViolation();
            }
        } else if (matchRequestAsync.getCorrelationId() != null) {
            valid = false;
            LOG.error("isValid", "", "For SimpleSDK callback mechanism URL cannot contains CorrelationId", new Object[0]);
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidCallbackURL.simpleSDK}").addConstraintViolation();
        }
        return valid;
    }
}

