/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints;

import com.avaya.ingensg.ce.wa.imrest.common.model.MatchRequestSync;
import com.avaya.ingensg.ce.wa.imrest.common.model.Service;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidGroupResource;
import com.avaya.ingensg.ce.wa.imrest.common.utils.MatchType;
import com.avaya.ucam.common.logger.api.EmLogger;
import com.avaya.ucam.common.logger.factory.EmLoggerFactoryImpl;
import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class ValidGroupResourceValidator
implements ConstraintValidator<ValidGroupResource, MatchRequestSync> {
    private static final String GROUP_RESOURCE = "GROUP_RESOURCE";
    private static final EmLogger LOG = EmLoggerFactoryImpl.INSTANCE.getLogger(ValidGroupResourceValidator.class);

    public void initialize(ValidGroupResource constraintAnnotation) {
    }

    public boolean isValid(MatchRequestSync matchRequestSync, ConstraintValidatorContext context) {
        String methodName = "isValid";
        if (null == matchRequestSync) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        Boolean valid = true;
        String taskType = matchRequestSync.getTaskType();
        Map<Integer, Service> serviceMap = matchRequestSync.getServiceMap();
        String matchType = matchRequestSync.getMatchType();
        this.setMatchType(matchRequestSync, taskType, matchType);
        if (GROUP_RESOURCE.equals(taskType) && null != serviceMap) {
            String workRequestId = matchRequestSync.getWorkRequestId();
            if (workRequestId == null || workRequestId.isEmpty()) {
                valid = false;
                LOG.error("isValid", "", "For a SINGLE_RESOURCE workRequestId must not be null or empty {}", new Object[]{matchRequestSync});
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidGroupResource.workRequestId}").addConstraintViolation();
            }
            Integer totalResourceCount = 0;
            for (Service service : serviceMap.values()) {
                Integer resourceCount = service.getResourceCount();
                Integer priority = service.getPriority();
                Integer rank = service.getRank();
                if (null == resourceCount) {
                    valid = false;
                    LOG.error("isValid", "", "For a GROUP_RESOURCE request resourceCount cannot be null. {}", new Object[]{matchRequestSync});
                    context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidGroupResource.resourceCount}").addConstraintViolation();
                } else if (resourceCount > 10) {
                    valid = false;
                    LOG.error("isValid", "", "For each service resourceCount must not exceed the max {}. {}", new Object[]{10, matchRequestSync});
                    context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidGroupResource.maxResourceCountPerService}").addConstraintViolation();
                } else {
                    totalResourceCount = totalResourceCount + resourceCount;
                }
                if (null != priority) {
                    valid = false;
                    LOG.error("isValid", "", "For a GROUP_RESOURCE request priority must not be specified. {}", new Object[]{matchRequestSync});
                    context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidGroupResource.priority}").addConstraintViolation();
                }
                if (null == rank) continue;
                valid = false;
                LOG.error("isValid", "", "For a GROUP_RESOURCE request rank must not be specified. {}", new Object[]{matchRequestSync});
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidGroupResource.rank}").addConstraintViolation();
            }
            if (totalResourceCount > 50) {
                valid = false;
                LOG.error("isValid", "", "The GROUP_RESOURCE request resourceCount exceeds the max 50. {}", new Object[]{matchRequestSync});
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidGroupResource.maxResourceCount}").addConstraintViolation();
            }
        }
        if (GROUP_RESOURCE.equals(taskType) && null != matchType && MatchType.findMatchTypeString(matchType) == null) {
            valid = false;
            LOG.error("isValid", "", " The provided match type must be one of PARTIAL or FULL", new Object[]{matchRequestSync});
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidGroupResource.matchType}").addConstraintViolation();
        }
        return valid;
    }

    private void setMatchType(MatchRequestSync matchRequestSync, String taskType, String matchType) {
        if (GROUP_RESOURCE.equals(taskType) && matchType == null) {
            matchRequestSync.setMatchType("FULL");
        }
    }
}

