/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints;

import com.avaya.ingensg.ce.wa.imrest.common.model.MatchUpdateRequest;
import com.avaya.ingensg.ce.wa.imrest.common.model.Service;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidRequestUpdate;
import com.avaya.ucam.common.logger.api.EmLogger;
import com.avaya.ucam.common.logger.factory.EmLoggerFactoryImpl;
import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class ValidRequestUpdateValidator
implements ConstraintValidator<ValidRequestUpdate, MatchUpdateRequest> {
    private static final EmLogger LOG = EmLoggerFactoryImpl.INSTANCE.getLogger(ValidRequestUpdateValidator.class);

    public void initialize(ValidRequestUpdate constraintAnnotation) {
    }

    public boolean isValid(MatchUpdateRequest matchUpdateRequest, ConstraintValidatorContext context) {
        String methodName = "isValid";
        context.disableDefaultConstraintViolation();
        Map<Integer, Service> serviceMap = matchUpdateRequest.getServiceMap();
        boolean isValid = true;
        boolean isValidRank = true;
        if (null != serviceMap) {
            for (Service service : serviceMap.values()) {
                if (service != null) {
                    boolean isValidResourceCount = this.checkForResourceCount(matchUpdateRequest, context, service);
                    boolean isValidPriority = this.checkForPriority(matchUpdateRequest, context, service);
                    isValidRank = isValidRank && this.checkForRank(matchUpdateRequest, context, service);
                    boolean isValidCorrelationId = this.checkForCorrelationId(matchUpdateRequest, context);
                    isValid = isValidResourceCount && isValidPriority && isValidCorrelationId;
                    continue;
                }
                LOG.info("isValid", "", "ServiceMap has a null service. Accepted.", new Object[0]);
            }
        }
        return isValid;
    }

    private boolean checkForCorrelationId(MatchUpdateRequest matchUpdateRequest, ConstraintValidatorContext context) {
        String methodName = "checkForCorrelationId";
        boolean isValid = true;
        if (matchUpdateRequest.getCallbackMechanism() != null && matchUpdateRequest.getCallbackMechanism().equals("EventingFramework") && (matchUpdateRequest.getCorrelationId() == null || matchUpdateRequest.getCorrelationId().isEmpty())) {
            LOG.error("checkForCorrelationId", "", "For a WORK_UPDATE , correlationId should be available if the callback mechanism is 'EventingFramework' . {}", new Object[]{matchUpdateRequest});
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidRequestUpdate.correlationId}").addConstraintViolation();
            isValid = false;
        }
        return isValid;
    }

    private boolean checkForPriority(MatchUpdateRequest matchUpdateRequest, ConstraintValidatorContext context, Service service) {
        String methodName = "checkForPriority";
        boolean isValid = true;
        Integer priority = service.getPriority();
        if (null == priority) {
            LOG.error("checkForPriority", "", "For a WORK_UPDATE request priority must be 1 to 10 . {}", new Object[]{matchUpdateRequest});
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidRequestUpdate.priority}").addConstraintViolation();
            isValid = false;
        }
        return isValid;
    }

    private boolean checkForRank(MatchUpdateRequest matchUpdateRequest, ConstraintValidatorContext context, Service service) {
        String methodName = "checkForRank";
        boolean isValid = true;
        Integer rank = service.getRank();
        if (null != rank) {
            LOG.error("checkForRank", "", "For a WORK_UPDATE request rank must must not be specified . {}", new Object[]{matchUpdateRequest});
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidRequestUpdate.rank}").addConstraintViolation();
            isValid = false;
        }
        return isValid;
    }

    private boolean checkForResourceCount(MatchUpdateRequest matchUpdateRequest, ConstraintValidatorContext context, Service service) {
        String methodName = "checkForResourceCount";
        boolean isValid = true;
        Integer resourceCount = service.getResourceCount();
        if (null != resourceCount && resourceCount != 1) {
            LOG.error("checkForResourceCount", "", "For a WORK_UPDATE request resourceCount must be null or 1. {}", new Object[]{matchUpdateRequest});
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidRequestUpdate.resourceCount}").addConstraintViolation();
            isValid = false;
        }
        return isValid;
    }
}

