/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints;

import com.avaya.ingensg.ce.wa.imrest.common.model.MatchRequestSync;
import com.avaya.ingensg.ce.wa.imrest.common.model.Service;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSingleResource;
import com.avaya.ucam.common.logger.api.EmLogger;
import com.avaya.ucam.common.logger.factory.EmLoggerFactoryImpl;
import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class ValidSingleResourceSyncValidator
implements ConstraintValidator<ValidSingleResource, MatchRequestSync> {
    private static final EmLogger LOG = EmLoggerFactoryImpl.INSTANCE.getLogger(ValidSingleResourceSyncValidator.class);

    public void initialize(ValidSingleResource constraintAnnotation) {
    }

    public boolean isValid(MatchRequestSync matchRequestSync, ConstraintValidatorContext context) {
        String methodName = "isValid";
        if (null == matchRequestSync) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        Boolean valid = true;
        String taskType = matchRequestSync.getTaskType();
        String matchType = matchRequestSync.getMatchType();
        Map<Integer, Service> serviceMap = matchRequestSync.getServiceMap();
        if ("SINGLE_RESOURCE".equals(taskType) && null != serviceMap) {
            String workRequestId = matchRequestSync.getWorkRequestId();
            if (this.isNotValidWorkRequestId(workRequestId)) {
                valid = false;
                LOG.error("isValid", "", "For a SINGLE_RESOURCE workRequestId must not be null or empty {}", new Object[]{workRequestId});
                context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSingleResource.workRequestId}").addConstraintViolation();
            }
            for (Service service : serviceMap.values()) {
                Integer rank;
                Integer priority;
                Integer resourceCount = service.getResourceCount();
                if (this.isValidService(resourceCount, priority = service.getPriority(), rank = service.getRank(), matchRequestSync, context)) continue;
                valid = false;
                break;
            }
        }
        if (this.isMatchTypeNotAllowed(valid, taskType, matchType)) {
            valid = false;
            LOG.error("isValid", "", "For a SINGLE_RESOURCE request matchType must not be specified {}", new Object[]{matchRequestSync});
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSingleResource.matchType}").addConstraintViolation();
        }
        return valid;
    }

    private boolean isNotValidWorkRequestId(String workRequestId) {
        return workRequestId == null || workRequestId.isEmpty();
    }

    private boolean isValidService(Integer resourceCount, Integer priority, Integer rank, MatchRequestSync matchRequestSync, ConstraintValidatorContext context) {
        String methodName = "isValidService";
        boolean valid = true;
        if (rank != null && rank < 1) {
            valid = false;
            LOG.error("isValidService", "", "For a SINGLE_RESOURCE request rank must be null or a value between 1 - 2^31-1 {}", new Object[]{matchRequestSync});
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSingleResource.rank}").addConstraintViolation();
        }
        if (null != resourceCount && resourceCount != 1) {
            valid = false;
            LOG.error("isValidService", "", "For a SINGLE_RESOURCE request resourceCount must be null or 1. {}", new Object[]{matchRequestSync});
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSingleResource.resourceCount}").addConstraintViolation();
        }
        if (null == priority) {
            valid = false;
            LOG.error("isValidService", "", "For a SINGLE_RESOURCE request a priority must be specified. {}", new Object[]{matchRequestSync});
            context.buildConstraintViolationWithTemplate("{com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSingleResource.priority}").addConstraintViolation();
        }
        return valid;
    }

    private boolean isMatchTypeNotAllowed(boolean valid, String taskType, String matchType) {
        return valid && "SINGLE_RESOURCE".equals(taskType) && matchType != null && !matchType.trim().isEmpty();
    }
}

