/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.IGenerator;
import com.avaya.sce.runtime.IOutputGenerator;
import com.avaya.sce.runtime.Message;
import com.avaya.sce.runtime.internal.AttachmentFinder;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.util.ArrayList;

public class Email
extends Message
implements IGenerator {
    private String body;
    private String subject;
    private ArrayList<EmailAttachment> attachments = new ArrayList();

    public final String getEmailSubject() {
        return this.subject;
    }

    public final String getEmailBody() {
        StringBuilder sb = new StringBuilder(new StringBuilder(this.body));
        sb = this.fillInMessageBodyVariables(sb);
        return sb.toString();
    }

    public final ArrayList<EmailAttachment> getEmailAttachments() {
        return this.attachments;
    }

    public final void setEmailSubject(String emailSubject) {
        this.subject = emailSubject;
    }

    public final void setEmailBody(String emailbody) {
        this.body = emailbody;
    }

    public final void addEmailAttachment(EmailAttachment attachment) {
        this.attachments.add(attachment);
    }

    @Override
    public void generate(IOutputGenerator generator) {
    }

    public void updateEmail(SCESession mySession) {
    }

    public class EmailAttachment {
        String URL;
        AttachmentType type;
        String contentId;

        public EmailAttachment(String URL2, AttachmentType type) {
            this.URL = URL2;
            this.type = type;
        }

        public EmailAttachment(String URL2, AttachmentType type, String contentId) {
            this(URL2, type);
            this.contentId = contentId;
        }

        public void setType(AttachmentType type) {
            this.type = type;
        }

        public void setURL(String URL2) {
            this.URL = URL2;
        }

        public AttachmentType getType() {
            return this.type;
        }

        public String getURL(SCESession mySession) {
            String url = this.URL;
            if (this.type.equals((Object)AttachmentType.INTERNAL)) {
                String name;
                try {
                    name = AttachmentFinder.getAttachmentFinder(mySession.getCurrentLanguage()).resolveResourceName(url);
                }
                catch (Exception e) {
                    throw new SCERuntimeException("Error resolving attachment file:" + this.URL, e);
                }
                url = mySession.getFileURL(name).toString();
            } else if (this.type.equals((Object)AttachmentType.VARIABLE) && url != null && !url.isEmpty()) {
                url = mySession.getVariableField(new VariableName(url)).getStringValue();
            }
            if (url != null && url.length() > 0 && this.getContentId() != null && this.getContentId().length() > 0) {
                url = url + "?Content-ID:" + this.getContentId();
            }
            return url;
        }

        public String getContentId() {
            return this.contentId;
        }

        public void setContentId(String contentId) {
            this.contentId = contentId;
        }
    }

    public static enum AttachmentType {
        INTERNAL,
        EXTERNAL,
        VARIABLE;

    }
}

