/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.tracking.Trackable;
import com.avaya.sce.runtimecommon.ICollection;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableTypeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class SimpleCollection
implements ICollection {
    int index = -1;
    IVariableField field;
    ArrayList<Object> values = new ArrayList();
    String varName;
    int mark = -1;

    public SimpleCollection(IVariableField field, String varName) {
        this.field = field;
        this.varName = varName;
    }

    public boolean hasMore() {
        return this.index < this.values.size() && this.index != -1;
    }

    public boolean hasPrevious() {
        return this.index > 1;
    }

    public void next() throws IllegalStateException {
        try {
            Object val;
            if (this.index > 0) {
                val = this.field.getObjectValue();
                this.values.set(this.index - 1, val);
            }
            val = this.values.get(this.index);
            this.field.setValue(val);
            ++this.index;
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            Trackable.formatException(e, sb);
            throw new IllegalStateException(sb.toString());
        }
    }

    public void previous() throws IllegalStateException {
        try {
            Object val;
            if (this.index > 0) {
                val = this.field.getObjectValue();
                this.values.set(this.index - 1, val);
            }
            --this.index;
            val = this.values.get(this.index - 1);
            this.field.setValue(val);
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            Trackable.formatException(e, sb);
            throw new IllegalStateException(sb.toString());
        }
    }

    public void reset() {
        if (this.index > 0) {
            Object val = this.field.getObjectValue();
            this.values.set(this.index - 1, val);
        }
        this.index = 0;
    }

    public int size() {
        return this.values.size();
    }

    public void append() {
        this.values.add(this.field.getObjectValue());
        this.index = this.values.size();
    }

    public void append(String value) {
        this.field.setValue(value);
        this.append();
    }

    public void append(Object value) {
        this.field.setValue(value);
        this.append();
    }

    public void append(String varName, IRuntimeSession mySession) {
        IVariable var = mySession.getVariable(varName);
        if (!var.isSimpleVariable()) {
            throw new VariableTypeException("Variable is complex cannot append to a simple variable");
        }
        IVariableField field = var.getSimpleVariable();
        this.append(field.getObjectValue());
    }

    public void removeAll() {
        while (this.values.size() > 0) {
            this.values.remove(0);
        }
        this.index = -1;
        this.field.setValue("");
    }

    public void delete() {
        this.values.remove(this.index - 1);
        if (this.index > this.values.size()) {
            --this.index;
        }
        if (this.index > 0) {
            Object val = this.values.get(this.index - 1);
            this.field.setValue(val);
        }
    }

    public void insert(String varName, IRuntimeSession mySession) {
        IVariable var = mySession.getVariable(varName);
        if (!var.isSimpleVariable()) {
            throw new VariableTypeException("Variable is complex cannot insert to a simple variable");
        }
        IVariableField field = var.getSimpleVariable();
        this.insert(field.getObjectValue());
    }

    private void insert(Object object) {
        if (this.index <= 0) {
            this.append(object);
        } else {
            this.values.add(this.index - 1, object);
            this.field.setValue(object);
        }
    }

    public void sort(boolean descending, String fieldName, IRuntimeSession mySession) {
        final boolean isDescending = descending;
        boolean doNumeric = true;
        for (Object item : this.values) {
            try {
                Double.parseDouble(item.toString());
            }
            catch (Exception e) {
                doNumeric = false;
                break;
            }
        }
        final boolean numericSort = doNumeric;
        Collections.sort(this.values, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String f1 = o1.toString();
                String f2 = o2.toString();
                if (!numericSort) {
                    if (isDescending) {
                        return f2.compareTo(f1);
                    }
                    return f1.compareTo(f2);
                }
                double i1 = 0.0;
                double i2 = 0.0;
                i1 = Double.parseDouble(f1);
                i2 = Double.parseDouble(f2);
                if (isDescending) {
                    if (i2 > i1) {
                        return 1;
                    }
                    if (i2 == i1) {
                        return 0;
                    }
                    if (i2 < i1) {
                        return -1;
                    }
                    return 0;
                }
                if (i1 > i2) {
                    return 1;
                }
                if (i1 == i2) {
                    return 0;
                }
                if (i1 < i2) {
                    return -1;
                }
                return 0;
            }
        });
        this.index = 0;
        this.next();
    }

    public static void append(SCESession mySession, String varName, Object object) {
        IVariable var = mySession.getVariable(varName);
        if (!var.isSimpleVariable()) {
            throw new VariableTypeException("Variable is complex cannot append to a simple variable");
        }
        IVariableField field = var.getSimpleVariable();
        SimpleCollection collection = !var.isCollection() ? (SimpleCollection)var.addCollection() : (SimpleCollection)var.getCollection();
        field.setValue(object);
        collection.append();
    }

    public static void insert(SCESession mySession, String varName, Object object) {
        SimpleCollection collection;
        IVariable var = mySession.getVariable(varName);
        if (var.isSimpleVariable()) {
            IVariableField field = var.getSimpleVariable();
            if (!var.isCollection()) {
                collection = new SimpleCollection(field, varName);
                collection = (SimpleCollection)var.addCollection();
            } else {
                collection = (SimpleCollection)var.getCollection();
            }
        } else {
            throw new VariableTypeException("Variable is complex cannot insert into a simple variable");
        }
        collection.insert(object);
    }

    public static void delete(SCESession mySession, String varName) {
        IVariable var = mySession.getVariable(varName);
        if (!var.isCollection()) {
            throw new VariableTypeException("Variable is not a collection");
        }
        ICollection collection = var.getCollection();
        collection.delete();
    }

    public void dispose() {
        this.field = null;
        this.values.clear();
        this.values = null;
    }

    public int mark() {
        if (this.index != -1) {
            this.mark = this.index - 1;
        }
        return this.mark;
    }

    public void resetToMark() {
        Object val;
        if (this.index > 0) {
            val = this.field.getObjectValue();
            this.values.set(this.index - 1, val);
        }
        if (this.mark != -1) {
            this.index = this.mark;
            val = this.values.get(this.index);
            this.field.setValue(val);
            ++this.index;
        } else {
            this.index = 0;
        }
    }
}

