/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.AppServlet;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.LoggerUtil;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.StackUnsynchronized;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Map;
import javax.servlet.ServletException;

public class SubflowReturn
extends AppServlet {
    private static final long serialVersionUID = 454804369460696896L;
    private String subflowReturnName = null;

    public SubflowReturn() {
        String[] split = ((Object)((Object)this)).getClass().getName().split("\\.");
        if (split.length != 4) {
            throw new IllegalStateException("Unexpected format of SubflowReturn classname!  Expects \"flow.subflow.{subflowName}.{className}");
        }
        this.subflowReturnName = split[2] + "-" + this.getName();
    }

    public String getSubflowReturnName() {
        return this.subflowReturnName;
    }

    @Override
    void handleRequest(SCESession mySession) throws IOException, ServletException {
        if (mySession.getSubflowExitPointStack().peek() == null) {
            throw new SCERuntimeException("Subflow exit point stack is empty!");
        }
        StackUnsynchronized stack = mySession.getSubflowExitPointStack();
        Map exitPtMap = (Map)mySession.getSubflowExitPointStack().pop();
        String nextServlet = (String)exitPtMap.get(this.getSubflowReturnName());
        if (nextServlet == null) {
            ArrayList<Map<String, String>> clone = new ArrayList<Map<String, String>>((Collection<Map<String, String>>)stack);
            clone.add(exitPtMap);
            LoggerUtil.writeTrace((IRuntimeSession)mySession, (int)1, (String)("Unable to find next servlet in subflow exit point map.  Return node: " + this.getSubflowReturnName() + ".  Checking other exit point maps as well as backward compatible formats."));
            String testKey = (String)exitPtMap.keySet().iterator().next();
            if (testKey.indexOf(45) == -1) {
                nextServlet = this.getBackwardCompatNextServlet(mySession, clone);
            } else {
                int popcount = 0;
                ListIterator it = stack.listIterator(stack.size());
                while (it.hasPrevious()) {
                    exitPtMap = (Map)it.previous();
                    ++popcount;
                    nextServlet = (String)exitPtMap.get(this.getSubflowReturnName());
                    if (nextServlet == null) continue;
                    LoggerUtil.writeTrace((IRuntimeSession)mySession, (int)2, (String)("Subflow exit point stack did not match current frame; an event handler most likely caused the discrepancy.  Found the correct stack frame " + popcount + " frame(s) deep."));
                    for (int i = 0; i < popcount; ++i) {
                        stack.pop();
                    }
                }
            }
            if (nextServlet == null) {
                StringBuilder sb = new StringBuilder("Discrepancy detected in subflow exit point stack!  Searching for \"" + this.getSubflowReturnName() + "\".");
                sb.append("\n\t" + clone + "  (note: stack order is reversed)");
                LoggerUtil.writeTrace((IRuntimeSession)mySession, (int)4, (String)sb.toString());
                throw new SCERuntimeException("Next servlet not provided in subflow exit point map for return node \"" + this.getSubflowReturnName() + "\"");
            }
            clone.clear();
            clone = null;
        }
        LoggerUtil.writeTrace((IRuntimeSession)mySession, (int)1, (String)("Subflow return node \"" + this.getSubflowReturnName() + "\" forwarding to \"" + nextServlet + "\""));
        this.forward(mySession, nextServlet);
    }

    private String getBackwardCompatNextServlet(SCESession mySession, ArrayList<Map<String, String>> subflowStack) {
        LoggerUtil.writeTrace((IRuntimeSession)mySession, (int)3, (String)"Subflow exit point identifiers appear to be the old format.  The project should be re-generated! ");
        int popcount = 0;
        ListIterator<Map<String, String>> it = subflowStack.listIterator(subflowStack.size());
        while (it.hasPrevious()) {
            Map<String, String> exitPtMap = it.previous();
            ++popcount;
            String nextServlet = exitPtMap.get(this.getName());
            if (nextServlet == null) continue;
            LoggerUtil.writeTrace((IRuntimeSession)mySession, (int)2, (String)("Subflow exit point stack did not match current frame; an event handler most likely caused the discrepancy.  Found the correct stack frame " + popcount + " frame(s) deep."));
            for (int i = 0; i < popcount - 1; ++i) {
                mySession.getSubflowExitPointStack().pop();
            }
            return nextServlet;
        }
        return null;
    }
}

