/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.html.genmodel;

import com.avaya.ade.common.utils.StringUtils;
import com.avaya.sce.runtime.Textset;
import com.avaya.sce.runtime.html.genmodel.Element;
import com.avaya.sce.runtime.html.genmodel.WebForm;
import com.avaya.sce.runtime.internal.TextsetFinder;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ChoiceInput
extends Element {
    public static final String TYPE_RADIO = "Radio";
    public static final String TYPE_DROPDOWN = "Dropdown";
    public static final String VALUE_SEPARATOR_PATTERN = "\\s*,\\s*";
    private String name;
    private String label;
    private String buttonType;
    private String choiceVariable;
    private String choiceTextset;
    private ChoiceType choiceType;
    private String choiceValues;

    public ChoiceInput(String name, String label, String buttonType, String choiceVariable, String choiceTextset, ChoiceType choiceType, String choiceValues) {
        this.name = name;
        this.label = label;
        this.choiceTextset = choiceTextset;
        this.buttonType = buttonType;
        this.choiceVariable = choiceVariable;
        this.choiceType = choiceType;
        this.choiceValues = choiceValues;
    }

    public ChoiceInput(String name, String label, String buttonType, String choiceVariable, String choiceTextset, ChoiceType choiceType) {
        this.name = name;
        this.label = label;
        this.choiceTextset = choiceTextset;
        this.buttonType = buttonType;
        this.choiceVariable = choiceVariable;
        this.choiceType = choiceType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public String getType() {
        return this.buttonType;
    }

    public String getChoicesVariable() {
        return this.choiceVariable;
    }

    public String getChoicesTextset() {
        return this.choiceTextset;
    }

    public ChoiceType getChoiceType() {
        return this.choiceType;
    }

    public String getChoiceValues() {
        return this.choiceValues;
    }

    public static String getChoice(String name, ChoiceType cType, SCESession session) {
        if (cType == ChoiceType.TEXTSET) {
            return ChoiceInput.getTextset(name, session);
        }
        return ChoiceInput.getVariableChoice(name, session);
    }

    public static String[] getChoices(String name, ChoiceType cType, SCESession session) {
        if (cType == ChoiceType.CHOICEVALUES) {
            return name.trim().split(VALUE_SEPARATOR_PATTERN);
        }
        if (cType == ChoiceType.TEXTSET) {
            return ChoiceInput.getTextsetChoices(name, session);
        }
        return ChoiceInput.getVariableChoices(name, session);
    }

    public static String[] getChoiceNames(String name, SCESession session) {
        return ChoiceInput.getTextsetChoices(name, session);
    }

    private static String getVariableChoice(String name, SCESession session) {
        String value = "";
        if (!name.isEmpty() && session != null) {
            VariableName varName = new VariableName(name);
            value = session.getVariableField(varName).getStringValue();
        }
        return value;
    }

    private static String[] getVariableChoices(String name, SCESession session) {
        ArrayList<String> choices = new ArrayList<String>();
        if (!name.isEmpty() && session != null) {
            VariableName varName = new VariableName(name);
            IVariable variable = session.getVariable(name);
            if (variable.isCollection()) {
                variable.getCollection().reset();
                while (variable.getCollection().hasMore()) {
                    variable.getCollection().next();
                    String value = session.getVariableField(varName).getStringValue();
                    choices.add(value);
                }
            } else {
                String value = session.getVariableField(varName).getStringValue();
                return value.trim().split(VALUE_SEPARATOR_PATTERN);
            }
        }
        return choices.toArray(new String[0]);
    }

    protected static String getTextset(String name, SCESession session) {
        if (name.isEmpty() || session == null) {
            return "";
        }
        String language = session.getCurrentLanguage();
        StringTokenizer st = new StringTokenizer(name, ":");
        Textset tset = TextsetFinder.load(st.nextToken(), language);
        tset.setMySession(session);
        String nextChoice = tset.getTextsetText(st.nextToken()).getText();
        return nextChoice;
    }

    private static String[] getTextsetChoices(String name, SCESession session) {
        if (name.isEmpty() || session == null) {
            return new String[0];
        }
        String choice = ChoiceInput.getTextset(name, session);
        return choice.trim().split(VALUE_SEPARATOR_PATTERN);
    }

    @Override
    public String toJsonString(WebForm form, SCESession session) {
        StringBuffer jsonSb = new StringBuffer("{\"inputtype\":\"choice\",\"name\":\"");
        String label = form.getL18nLabel(this.getName(), session, this.getLabel());
        String choiceName = this.getChoicesTextset();
        if (this.getChoiceType() == ChoiceType.VARIABLE) {
            choiceName = this.getChoicesVariable();
        }
        String[] choices = ChoiceInput.getChoices(choiceName, this.getChoiceType(), session);
        jsonSb.append(this.getName());
        jsonSb.append("\",");
        jsonSb.append("\"label\":\"");
        jsonSb.append(label);
        jsonSb.append("\",");
        jsonSb.append("\"selecttype\":'");
        jsonSb.append(this.getType());
        jsonSb.append("\",");
        jsonSb.append("\"choice\":[\"");
        jsonSb.append(StringUtils.toDelimitedString((String[])choices, (String)"\",\""));
        jsonSb.append("\"]");
        jsonSb.append("}");
        return jsonSb.toString();
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    public static enum ChoiceType {
        TEXTSET,
        VARIABLE,
        CHOICEVALUES;

    }
}

