/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.html.genmodel;

import com.avaya.sce.runtime.html.genmodel.Element;
import com.avaya.sce.runtime.html.genmodel.WebForm;
import com.avaya.sce.runtimecommon.SCESession;
import java.util.Arrays;
import java.util.Collection;

public class TextInput
extends Element {
    private String name;
    private String label;
    private String type;
    private String required;
    private String minLength;
    private Collection<String> add_props;

    public TextInput(String name, String label, String type, String required, String minLength, String additions) {
        this.name = name;
        this.label = label;
        this.type = type;
        this.required = required;
        this.minLength = minLength;
        if (additions.length() > 0) {
            this.add_props = Arrays.asList(additions.split(","));
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getRequired() {
        if (this.required.equals("Yes")) {
            return "required";
        }
        return "";
    }

    public String getMinLength() {
        return this.minLength;
    }

    public String getMinLengthAttr() {
        if (this.minLength.equals("")) {
            return "";
        }
        return "minlength=\"" + this.minLength + "\"";
    }

    public Collection<String> getAddtionalProps() {
        if (this.add_props == null) {
            this.add_props = Arrays.asList(new Object[0]);
        }
        return this.add_props;
    }

    @Override
    public String toJsonString(WebForm form, SCESession session) {
        StringBuffer jsonSb = new StringBuffer("{\"inputtype\":\"text\",\"name\":\"");
        String label = form.getL18nLabel(this.getName(), session, this.getLabel());
        jsonSb.append(this.getName());
        jsonSb.append("\",");
        jsonSb.append("\"label\":\"");
        jsonSb.append(label);
        jsonSb.append("\",");
        jsonSb.append("\"type\":\"");
        jsonSb.append(this.getType());
        jsonSb.append("\",");
        jsonSb.append("\"required\":\"");
        jsonSb.append(this.getRequired());
        jsonSb.append("\",");
        jsonSb.append("\"value\":\"");
        jsonSb.append(session.getVariableFieldValue(this.getName()));
        jsonSb.append("\"");
        if (!this.getMinLength().equals("")) {
            jsonSb.append(",");
            jsonSb.append("\"minlen\":");
            jsonSb.append(this.getMinLength());
        }
        if (this.add_props != null) {
            for (String prop : this.add_props) {
                jsonSb.append(",");
                String[] nameValue = prop.split("=");
                jsonSb.append("\"" + nameValue[0] + "\"");
                jsonSb.append(":" + nameValue[1]);
            }
        }
        jsonSb.append("}");
        return jsonSb.toString();
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }
}

