/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.internal;

import com.avaya.sce.runtime.Media;
import com.avaya.sce.runtime.internal.ItemFinder;
import com.avaya.sce.runtime.internal.ResourceFinder;
import com.avaya.sce.runtimecommon.SCERuntimeException;

public class MediaFinder
extends ResourceFinder {
    public static final String TYPE = "MEDIA";

    public static MediaFinder getMediaFinder(String language) {
        return (MediaFinder)ItemFinder.getFinder(TYPE, language);
    }

    public static Media load(String name, String language) {
        Media media = null;
        if (name != null) {
            try {
                media = (Media)MediaFinder.getMediaFinder(language).getInstance(name);
            }
            catch (Exception e) {
                throw new SCERuntimeException("Error instantiating media", e);
            }
        }
        return media;
    }

    public MediaFinder(String appLanguage) {
        super(appLanguage);
    }

    @Override
    protected String resolveName(String simpleName) {
        StringBuilder className = new StringBuilder(100);
        className.append(this.appLanguage);
        className.append(".");
        className.append("media");
        className.append(".");
        className.append(simpleName);
        return className.toString();
    }

    @Override
    public String resolveResourceName(String simpleName) {
        return this.resolveResourceName(simpleName, "audio");
    }

    public String resolveResourceName(String simpleName, String mediaPath) {
        StringBuilder itemName = new StringBuilder(100);
        itemName.append("/data");
        itemName.append("/");
        itemName.append(this.appLanguage);
        itemName.append("/");
        itemName.append("media");
        itemName.append("/");
        itemName.append(mediaPath);
        itemName.append("/");
        itemName.append(simpleName);
        return itemName.toString();
    }
}

