/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.perf;

import com.avaya.sce.runtimecommon.ICounter;

public class Counter
implements ICounter {
    private double min;
    private double max;
    private double average;
    private double totalSamples;
    private double totalTimeSquaresSum;
    private double standardDeviation;
    private double totalTime;
    private String name;

    public Counter(String name) {
        this.name = name;
        this.clear();
    }

    public synchronized void update(double value) {
        this.totalSamples += 1.0;
        this.min = Math.min(value, this.min);
        this.max = Math.max(value, this.max);
        this.totalTime += value;
        this.totalTimeSquaresSum += value * value;
        this.average = this.totalTime / this.totalSamples;
        this.standardDeviation = Math.sqrt(this.totalTimeSquaresSum / this.totalSamples - this.average * this.average);
    }

    public synchronized void clear() {
        this.max = -1.0;
        this.min = Double.MAX_VALUE;
        this.totalSamples = 0.0;
        this.totalTimeSquaresSum = 0.0;
        this.average = 0.0;
        this.standardDeviation = 0.0;
        this.totalTime = 0.0;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized double getAverage() {
        return this.average;
    }

    public synchronized double getMax() {
        return this.max;
    }

    public synchronized double getMin() {
        if (this.min == Double.MAX_VALUE) {
            return -1.0;
        }
        return this.min;
    }

    public synchronized double getStandardDeviation() {
        return this.standardDeviation;
    }

    public synchronized double getTotalSamples() {
        return this.totalSamples;
    }
}

