/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.varoperations;

import com.avaya.sce.runtime.varoperations.AssignmentOperation;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.VariableName;

public class Concatenate
extends AssignmentOperation {
    String destName;
    String sourceName;
    boolean sourceIsConstant;

    public Concatenate(String destName, String sourceName, boolean sourceIsConstant) {
        this.destName = destName;
        this.sourceName = sourceName;
        this.sourceIsConstant = sourceIsConstant;
    }

    @Override
    public void evaluate(IRuntimeSession mySession) {
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(2, "Concatenating [" + this.sourceName + "] to [" + this.destName + "]");
        }
        IVariableField destField = mySession.getVariableField(new VariableName(this.destName));
        if (this.sourceIsConstant) {
            destField.setValue(destField.getStringValue() + this.sourceName);
        } else {
            destField.setValue(destField.getStringValue() + this.getStringValue(mySession, new VariableName(this.sourceName)));
        }
    }
}

