/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.varoperations;

import com.avaya.sce.runtime.varoperations.AssignmentOperation;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.VariableName;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.CharBuffer;
import java.util.regex.Pattern;

public class PrepareAAI
extends AssignmentOperation {
    String mode;
    String ucidVar;
    String vdnNameVar;
    String collDigitsVar;
    String asaiVar;
    String resultVar;

    public PrepareAAI(String mode, String ucidVar, String vdnNameVar, String collDigitsVar, String asaiVar, String resultVar) {
        this.mode = mode;
        this.ucidVar = ucidVar;
        this.vdnNameVar = vdnNameVar;
        this.collDigitsVar = collDigitsVar;
        this.asaiVar = asaiVar;
        this.resultVar = resultVar;
    }

    static String stringToHex(String data) {
        StringBuilder result = new StringBuilder();
        try {
            for (int i = 0; i < data.length(); ++i) {
                char x = data.charAt(i);
                result.append(Integer.toString(x, 16));
            }
        }
        catch (Exception e) {
            throw new SCERuntimeException("Error converting string to hex character codes", e);
        }
        return result.toString();
    }

    static String convertDigitsToPackedBinaryCodedDecimal(String digits) {
        if (digits.length() == 0) {
            return "";
        }
        CharBuffer buffer = CharBuffer.allocate(digits.length() % 2 == 0 ? digits.length() : digits.length() + 1);
        buffer.append(digits);
        if (digits.length() % 2 != 0) {
            buffer.append('F');
        }
        StringBuilder collectedDigitsBuilder = new StringBuilder();
        collectedDigitsBuilder.append(String.format("%02X", digits.length()));
        for (int i = 0; i < buffer.limit(); ++i) {
            char digit = i % 2 == 0 ? buffer.get(i + 1) : buffer.get(i - 1);
            if (digit == '#') {
                collectedDigitsBuilder.append("C");
                continue;
            }
            if (digit == '0') {
                collectedDigitsBuilder.append("A");
                continue;
            }
            collectedDigitsBuilder.append(digit);
        }
        return collectedDigitsBuilder.toString();
    }

    public static String endcodeUcid(String ucid) {
        String temp = ucid.substring(0, 5);
        long node = Long.parseLong(temp, 10);
        temp = ucid.substring(5, 10);
        long seq = Long.parseLong(temp, 10);
        temp = ucid.substring(10);
        long stamp = Long.parseLong(temp, 10);
        ByteArrayOutputStream ba = new ByteArrayOutputStream(20);
        PrintStream ps = new PrintStream(ba);
        ps.printf("%1$04X", node);
        ps.printf("%1$04X", seq);
        ps.printf("%1$08X", stamp);
        temp = ba.toString();
        try {
            ba.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return temp;
    }

    @Override
    public void evaluate(IRuntimeSession mySession) {
        IVariableField asaiField;
        String aai;
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(2, "Preparing AAI [" + this.mode + "] ucid [" + this.ucidVar + "] asai [" + this.asaiVar + "] result [" + this.resultVar + "]");
        }
        if (this.mode.toLowerCase().equals("shared")) {
            IVariableField ucidField;
            String value;
            aai = this.asaiVar.length() == 0 && this.vdnNameVar.length() == 0 && this.collDigitsVar.length() == 0 ? "PD,00" : "PD,04";
            if (this.asaiVar.length() != 0) {
                asaiField = mySession.getVariableField(new VariableName(this.asaiVar));
                value = asaiField.getStringValue();
                if (value.length() > 96) {
                    mySession.throwRTException("Application data cannot be more than 96 characters");
                }
                if (value.length() > 0) {
                    aai = aai + ";C8," + PrepareAAI.stringToHex(asaiField.getStringValue());
                }
            }
            if (this.ucidVar.length() != 0 && (value = PrepareAAI.endcodeUcid((ucidField = mySession.getVariableField(new VariableName(this.ucidVar))).getStringValue())).length() > 0) {
                aai = aai + ";FA," + value;
            }
            if (this.vdnNameVar.length() != 0) {
                IVariableField vdnNameField = mySession.getVariableField(new VariableName(this.vdnNameVar));
                value = vdnNameField.getStringValue();
                if (value.length() > 15) {
                    mySession.throwRTException("VDN Name cannot be more than 15 characters");
                }
                if (value.length() > 0) {
                    aai = aai + ";F5," + PrepareAAI.stringToHex(value);
                }
            }
            if (this.collDigitsVar.length() != 0) {
                IVariableField collDigitsField = mySession.getVariableField(new VariableName(this.collDigitsVar));
                value = collDigitsField.getStringValue();
                if (value.length() > 16) {
                    mySession.throwRTException("Collected Digits cannot be more than 16 digits");
                }
                if (!Pattern.matches("^[#*]|[0-9]+[#*]?", value)) {
                    mySession.throwRTException("Collected Digits are not in a valid format");
                }
                if (value.length() > 0) {
                    aai = aai + ";F8," + PrepareAAI.convertDigitsToPackedBinaryCodedDecimal(value);
                }
            }
        } else {
            asaiField = mySession.getVariableField(new VariableName(this.asaiVar));
            aai = "04" + PrepareAAI.stringToHex(asaiField.getStringValue());
        }
        IVariableField resultField = mySession.getVariableField(new VariableName(this.resultVar));
        resultField.setValue(aai);
    }
}

