/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.varoperations;

import com.avaya.sce.runtime.varoperations.AssignmentOperation;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;

public class SetCurrentLanguage
extends AssignmentOperation {
    private final String language;
    private final boolean languageIsConstant;

    public SetCurrentLanguage(String language, boolean languageIsConstant) {
        this.language = language;
        this.languageIsConstant = languageIsConstant;
    }

    @Override
    public void evaluate(IRuntimeSession mySession) {
        String newLanguage = "Error setting language";
        if (this.languageIsConstant) {
            if (mySession.isTraceEnabled()) {
                mySession.getTraceOutput().writeln(2, "Setting current language [" + this.language + "].");
            }
            newLanguage = this.language;
        } else {
            VariableName langVarName = new VariableName(this.language);
            IVariableField langVar = mySession.getVariableField(langVarName);
            if (langVar == null) {
                mySession.throwRTException("Set current language references variable that does not exist: [" + this.language + "]");
            } else {
                newLanguage = langVar.getStringValue();
                if (mySession.isTraceEnabled()) {
                    mySession.getTraceOutput().writeln(2, "Setting current language [" + newLanguage + "] from variable [" + this.language + "].");
                }
            }
        }
        ((SCESession)mySession).setCurrentLanguage(newLanguage);
    }
}

