/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.cs.pdc.service;

import com.avaya.cs.pdc.Config;
import com.avaya.cs.pdc.service.AbstractOperation;
import com.avaya.cs.pdc.service.Response;
import com.avaya.cs.pdc.service.connectionpooling.ExecutorPool;
import com.avaya.cs.pdc.service.connectionpooling.PdcCallableTask;
import com.avaya.cs.pdc.util.Logger;
import com.avaya.cs.pdc.util.Pair;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;

public abstract class AbstractHttpOperation
extends AbstractOperation {
    public AbstractHttpOperation(Config config, String ip, String id, String rid, String key, String json, String touchpoint, String groupId, Boolean aliasRequest) {
        super(config, ip, id, rid, key, json, touchpoint, groupId, aliasRequest);
    }

    abstract HttpRequestBase prepareHttpUriRequest() throws UnsupportedEncodingException;

    protected void addParams(HttpUriRequest httpRequest) throws URISyntaxException {
        URI uri = httpRequest.getURI();
        URIBuilder uriBuilder = new URIBuilder(uri);
        uriBuilder.removeQuery();
        if (StringUtils.isNotBlank((CharSequence)this.getRid())) {
            uriBuilder.addParameter("rid", this.getRid());
        }
        if (this.isAliasRequest()) {
            List<String> aliasIds = Arrays.asList(this.getId().split("\\s*,\\s*"));
            for (String aliasId : aliasIds) {
                uriBuilder.addParameter("alias", aliasId);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTouchpoint())) {
            uriBuilder.addParameter("touchpoint", this.getTouchpoint());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getGroupId())) {
            uriBuilder.addParameter("group", this.getGroupId());
        }
        if (this.shouldTheShortIdParameterBeAddedToTheRequest(httpRequest) && this.getConfig().isShortIdGeneration()) {
            uriBuilder.addParameter("shortid", "true");
        }
        if (this.shouldTheLeaseParameterBeAddedToTheRequest(httpRequest)) {
            uriBuilder.addParameter("lease", this.getConfig().getLeaseTime());
        }
        ((HttpRequestBase)httpRequest).setURI(uriBuilder.build());
    }

    @Override
    public Response execute() {
        Pair<Boolean, List<String>> validate = this.validate();
        Response response = null;
        if (!validate.getP1().booleanValue()) {
            return new Response(500, "Validation Error", StringUtils.join((Iterable)validate.getP2(), (String)"\r\n"));
        }
        response = this.prepareResponse();
        return response;
    }

    private Response prepareResponse() {
        Response response = null;
        HttpRequestBase httpUriRequest = null;
        Future<Response> futureResponse = null;
        try {
            httpUriRequest = this.prepareHttpUriRequest();
            this.addParams((HttpUriRequest)httpUriRequest);
            PdcCallableTask pdcCallableTask = new PdcCallableTask(httpUriRequest);
            ExecutorService executorService = ExecutorPool.getService(this.getConfig());
            futureResponse = executorService.submit(pdcCallableTask);
            response = futureResponse.get(Long.parseLong(this.getConfig().getTimeout()), TimeUnit.MILLISECONDS);
            return this.treatResponse(response);
        }
        catch (TimeoutException e) {
            Logger.error(null, "AbstractHttpOperation execute(): Exception occurred. Exception: " + e);
            return new Response(408, "Request Timeout", "NULL");
        }
        catch (IOException | URISyntaxException e) {
            Logger.error(null, "AbstractHttpOperation execute(): Exception occurred. Exception: " + e);
            return new Response(500, "Internal Server Error", "NULL");
        }
        catch (InterruptedException | ExecutionException e) {
            Logger.error(null, "AbstractHttpOperation execute(): Exception occurred. Exception: " + e);
            if (futureResponse != null) {
                futureResponse.cancel(true);
            }
            return new Response(500, "Internal Server Error", "NULL");
        }
    }

    private boolean shouldTheLeaseParameterBeAddedToTheRequest(HttpUriRequest httpRequest) {
        return (httpRequest.getMethod().equals("POST") || httpRequest.getMethod().equals("PUT")) && StringUtils.isNotEmpty((CharSequence)this.getConfig().getLeaseTime()) && !this.getConfig().getLeaseTime().equals("0");
    }

    private boolean shouldTheShortIdParameterBeAddedToTheRequest(HttpUriRequest httpRequest) {
        return httpRequest.getMethod().equals("POST");
    }
}

