/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.cs.pdc.service;

import com.avaya.cs.pdc.Config;
import com.avaya.cs.pdc.service.ContextStoreOperation;
import com.avaya.cs.pdc.service.PickUpServerStrategyFactory;
import com.avaya.cs.pdc.service.Response;
import com.avaya.cs.pdc.util.Logger;
import com.avaya.cs.pdc.util.Pair;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class AbstractOperation
implements ContextStoreOperation {
    private final String ip;
    private final String id;
    private final String rid;
    private final String key;
    private final String json;
    private final String touchpoint;
    private final String groupId;
    private final Config config;
    private final List<String> urls;
    private final List<String> geoUrls;
    private static ObjectMapper mapper = new ObjectMapper();
    private final boolean geoUrlsInUse;
    private final boolean aliasRequest;
    private static final String ID_AND_KEY_REG_EXP = "^[\\w\\-_~.]+$";
    private static final String KEY_REG_EXP = "^[\\w\\-_~.*]+$";

    public AbstractOperation(Config config, String ip, String id, String rid, String key, String json, String touchpoint, String groupId, boolean aliasRequest) {
        this.config = config;
        this.ip = ip;
        this.id = id;
        this.rid = rid;
        this.key = key;
        this.json = json;
        this.touchpoint = touchpoint;
        this.groupId = groupId;
        this.urls = config.getUrl();
        this.geoUrls = config.getGeoUrl();
        this.geoUrlsInUse = config.isGeoUrlsInUse();
        this.aliasRequest = aliasRequest;
    }

    abstract Pair<Boolean, List<String>> validate();

    protected Pair<Boolean, List<String>> composeValidation(Pair<Boolean, List<String>> first, Pair<Boolean, String> second) {
        ArrayList<String> errors = new ArrayList<String>();
        if (first != null && !first.getP1().booleanValue()) {
            errors.addAll((Collection)first.getP2());
        }
        if (!second.getP1().booleanValue()) {
            errors.add(second.getP2());
        }
        return new Pair<Boolean, List<String>>((first == null || first.getP1() != false) && second.getP1() != false, errors);
    }

    protected String applyValidVariableIP(String variableIP) {
        if (StringUtils.isNotBlank((CharSequence)variableIP)) {
            try {
                StringBuilder url = new StringBuilder();
                URI uri = new URI(this.getUrl());
                String protocol = uri.getScheme();
                protocol = protocol + "://";
                String path = uri.getPath();
                url.append(protocol);
                url.append(variableIP);
                url.append(path);
                return url.toString();
            }
            catch (URISyntaxException ex) {
                Logger.error(null, "Configured IP variable is invalid: Exception occurred: " + ex);
            }
        }
        return this.getUrl();
    }

    protected String getId() {
        return this.id;
    }

    protected String getIp() {
        return this.ip;
    }

    public String getRid() {
        return this.rid;
    }

    public boolean isAliasRequest() {
        return this.aliasRequest;
    }

    protected String getJson() {
        return this.json;
    }

    protected String getTouchpoint() {
        return this.touchpoint;
    }

    protected String getGroupId() {
        return this.groupId;
    }

    protected Config getConfig() {
        return this.config;
    }

    protected String getKey() {
        return this.key;
    }

    protected String getUrl() {
        if (this.geoUrlsInUse) {
            return PickUpServerStrategyFactory.getStrategy(this.config.getStrategy()).choose(this.geoUrls);
        }
        return PickUpServerStrategyFactory.getStrategy(this.config.getStrategy()).choose(this.urls);
    }

    protected static ObjectMapper getMapper() {
        return mapper;
    }

    public Pair<Boolean, String> isValidConfig() {
        boolean isEmpty = this.config == null;
        isEmpty = isEmpty || this.config.getUrl() == null;
        isEmpty = isEmpty || this.config.getUrl().isEmpty();
        isEmpty = isEmpty || StringUtils.isEmpty((CharSequence)this.config.getPassword());
        isEmpty = isEmpty || StringUtils.isEmpty((CharSequence)this.config.getUser());
        return new Pair<Boolean, String>(!isEmpty, isEmpty ? "The configuration is invalid" : null);
    }

    public Pair<Boolean, String> isValidId() {
        boolean isEmpty = StringUtils.isEmpty((CharSequence)this.id);
        if (isEmpty) {
            return new Pair<Boolean, String>(!isEmpty, isEmpty ? "The id parameter must not be empty" : null);
        }
        boolean isValidContextId = this.isStringAValidIdOrKeyIdentifier(this.id, ID_AND_KEY_REG_EXP);
        return new Pair<Boolean, String>(isValidContextId, isValidContextId ? null : "The id parameter supplied is not in the correct format");
    }

    public Pair<Boolean, String> isValidAliasId() {
        boolean isEmpty = StringUtils.isEmpty((CharSequence)this.id);
        boolean isValidAliasId = false;
        if (isEmpty) {
            return new Pair<Boolean, String>(!isEmpty, isEmpty ? "The id parameter must not be empty" : null);
        }
        List<String> aliasIds = Arrays.asList(this.getId().split("\\s*,\\s*"));
        for (String aliasId : aliasIds) {
            isValidAliasId = this.isStringAValidIdOrKeyIdentifier(aliasId, ID_AND_KEY_REG_EXP);
        }
        return new Pair<Boolean, String>(isValidAliasId, isValidAliasId ? null : "The id parameter supplied is not in the correct format");
    }

    public Pair<Boolean, String> isValidTouchpoint() {
        boolean isValidContextId = this.isStringAValidIdOrKeyIdentifier(this.id, ID_AND_KEY_REG_EXP);
        return new Pair<Boolean, String>(isValidContextId, isValidContextId ? null : "The touchpoint parameter supplied is not in the correct format");
    }

    public Pair<Boolean, String> isValidGroupId() {
        boolean isValidContextId = this.isStringAValidIdOrKeyIdentifier(this.id, ID_AND_KEY_REG_EXP);
        return new Pair<Boolean, String>(isValidContextId, isValidContextId ? null : "The groupId parameter supplied is not in the correct format");
    }

    public Pair<Boolean, String> isValidKey() {
        boolean isEmpty = StringUtils.isEmpty((CharSequence)this.key);
        if (isEmpty) {
            return new Pair<Boolean, String>(!isEmpty, isEmpty ? "The key parameter must not be empty" : null);
        }
        boolean isValidKey = this.isStringAValidIdOrKeyIdentifier(this.key, KEY_REG_EXP);
        return new Pair<Boolean, String>(isValidKey, isValidKey ? null : "The key parameter supplied is not in the correct format");
    }

    public Pair<Boolean, String> isValidJson() {
        boolean isEmpty = StringUtils.isEmpty((CharSequence)this.json);
        return new Pair<Boolean, String>(!isEmpty, isEmpty ? "The json string must not be empty" : null);
    }

    Response treatResponse(Response response) throws IOException {
        return response;
    }

    public boolean isGeoUrlsInUse() {
        return this.geoUrlsInUse;
    }

    private boolean isStringAValidIdOrKeyIdentifier(String string, String inputPattern) {
        Pattern pattern = Pattern.compile(inputPattern);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }
}

