/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.pdc.oceanaservices;

import com.avaya.runtimecommon.platforms.Toolkit;
import com.avaya.sce.pdc.oceanaservices.IOceanaServices;
import com.avaya.sce.pdc.oceanaservices.OceanaServicesException;
import com.avaya.sce.runtimecommon.IPlatformParams;
import com.avaya.sce.runtimecommon.ITraceInfo;
import com.avaya.sce.runtimecommon.PlatformSettings;
import com.avaya.sce.runtimecommon.SCESession;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class Simulation
implements IOceanaServices {
    private static final Logger LOGGER = Logger.getLogger(Simulation.class.getName());
    private static final String CONTEXTSTORE_DIR = "contextstore_dir";
    private static final String CONTEXT_LEASE_EXPIRETIME = "Avaya_Lease_Expiration";
    private static final String SCHEMA = "schema";
    private static final String DATA = "data";
    private static final String AUDIT = "audit";
    private static final String CONTEXT_ID = "contextId";
    private static final String SERVICE_MAP = "ServiceMap";
    private static final String CONTEXT_ID_DOES_NOT_EXIST = "ContextId does not exist";
    private static final String VERSION = "version";
    public static final int THOUSAND = 1000;
    private static final String CUSTOMER_HISTORY_FIELD = "customerHistory";
    private SCESession mySession;

    public Simulation(SCESession session) {
        this.mySession = session;
    }

    private String getLocPref(SCESession mySession) {
        IPlatformParams params = Toolkit.getToolkit((PlatformSettings)mySession.getPlatformSettings()).getPlatformParamsObject(mySession);
        String path = params.getValue("avaya.store.basepath");
        if (path == null) {
            path = "c:\\temp";
        }
        path = path + File.separator + CONTEXTSTORE_DIR;
        SCESession.createDirectoryStructure((File)new File(path));
        return path;
    }

    private String getContextFilePath(SCESession mySession) {
        String path = this.getLocPref(mySession);
        path = path + File.separator + "contextmap.properties";
        return path;
    }

    private File getContextFileName(SCESession mySession) {
        return new File(this.getContextFilePath(mySession));
    }

    private Properties loadContext(SCESession mySession) {
        File file = this.getContextFileName(mySession);
        return this.loadFromFile(file, mySession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadFromFile(File file, SCESession mySession) {
        FileInputStream ras = null;
        InputStreamReader isr = null;
        Properties props = new Properties();
        try {
            ras = new FileInputStream(file);
            isr = new InputStreamReader((InputStream)ras, "UTF-8");
            props.load(isr);
            Properties properties = props;
            return properties;
        }
        catch (Exception e) {
            if (mySession.isTraceEnabled()) {
                ITraceInfo tr = mySession.getTraceOutput();
                tr.writeln(1, "No file map found : " + e);
            }
        }
        finally {
            if (ras != null) {
                try {
                    ras.close();
                }
                catch (IOException e) {
                    mySession.throwRTException("Error closing file", (Exception)e);
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    mySession.throwRTException("Error closing file", (Exception)e);
                }
            }
        }
        return props;
    }

    private boolean checkExpired(String contextId, Properties p) throws OceanaServicesException {
        if (p.containsKey(contextId)) {
            String leaseExpireStr;
            long leaseExpire;
            JSONObject json;
            try {
                json = new JSONObject(p.getProperty(contextId));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "", e);
                return false;
            }
            if (json.has(CONTEXT_LEASE_EXPIRETIME) && (leaseExpire = Long.parseLong(leaseExpireStr = json.getString(CONTEXT_LEASE_EXPIRETIME))) < System.currentTimeMillis()) {
                this.checkTraceEnabled(contextId);
                p.remove(contextId);
                this.writeFile(p);
                return true;
            }
        }
        return false;
    }

    private void checkTraceEnabled(String contextId) {
        if (this.mySession.isTraceEnabled()) {
            ITraceInfo tr = this.mySession.getTraceOutput();
            tr.writeln(1, "Lease expired, removing context : " + contextId);
        }
    }

    private void writeFile(Properties p) throws OceanaServicesException {
        Writer writer = null;
        try {
            File file = new File(this.getContextFilePath(this.mySession));
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            p.store(writer, null);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "", ex);
            throw new OceanaServicesException("failed to write file: " + ex.getMessage());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "", e);
            }
        }
    }

    @Override
    public String createContextWithSchema(String data, String leaseTime, String groupId, String journeyElement, String topic, SCESession sceSession, String contextStoreIP) throws OceanaServicesException {
        JSONObject json = new JSONObject(data);
        String contextId = null;
        if (json.has(CONTEXT_ID)) {
            contextId = json.getString(CONTEXT_ID);
            json.remove(CONTEXT_ID);
        }
        if (contextId == null || "".equals(contextId.trim())) {
            int rndValue = new Random().nextInt(1000);
            contextId = "ctx_" + System.currentTimeMillis() + "_" + Integer.toString(rndValue);
        }
        Properties p = this.loadContext(this.mySession);
        this.checkExpired(contextId, p);
        if (leaseTime != null && !"".equals(leaseTime)) {
            String leaseExpireStr = Long.toString(System.currentTimeMillis() + Long.valueOf(leaseTime) * 1000L);
            json.put(CONTEXT_LEASE_EXPIRETIME, (Object)leaseExpireStr);
        }
        if (p.containsKey(contextId)) {
            throw new OceanaServicesException("ContextId already exists");
        }
        p.put(contextId, json.toString());
        if (this.mySession.isTraceEnabled()) {
            ITraceInfo tr = this.mySession.getTraceOutput();
            tr.writeln(1, "Creating context for : " + contextId);
        }
        this.writeFile(p);
        if (journeyElement != null) {
            this.updateJourney(contextId, journeyElement, contextStoreIP, null);
        }
        return contextId;
    }

    @Override
    public String getContextWithSchema(String contextId, String contextStoreIP, SCESession sceSession) throws OceanaServicesException {
        if (this.mySession.isTraceEnabled()) {
            ITraceInfo tr = this.mySession.getTraceOutput();
            tr.writeln(1, "Getting context and schema for : " + contextId);
        }
        Properties p = this.loadContext(this.mySession);
        this.checkExpired(contextId, p);
        if (p.containsKey(contextId)) {
            try {
                String context = p.getProperty(contextId);
                JSONObject json = new JSONObject(context);
                JSONObject schema = json.getJSONObject(SCHEMA);
                JSONObject data = json.getJSONObject(DATA);
                return "{\"data\": " + data.toString() + ", \"" + SCHEMA + "\":" + schema.toString() + "}";
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "", ex);
                throw new OceanaServicesException("failed to get context and schema for ContextId: " + ex.getMessage());
            }
        }
        throw new OceanaServicesException(CONTEXT_ID_DOES_NOT_EXIST);
    }

    @Override
    public void updateContextWithSchema(String contextId, String data, String groupId, String topic, String contextStoreIP, String journeyElement, SCESession sceSession) throws OceanaServicesException {
        if (this.mySession.isTraceEnabled()) {
            ITraceInfo tr = this.mySession.getTraceOutput();
            tr.writeln(1, "Updating context and schema for : " + contextId);
        }
        Properties p = this.loadContext(this.mySession);
        this.checkExpired(contextId, p);
        if (p.containsKey(contextId)) {
            try {
                JSONObject newjson = new JSONObject(data);
                JSONObject newData = newjson.getJSONObject(DATA);
                JSONObject newSchema = newjson.getJSONObject(SCHEMA);
                String context = p.getProperty(contextId);
                JSONObject json = new JSONObject(context);
                json.put(SCHEMA, (Object)newSchema);
                json.put(DATA, (Object)newData);
                p.put(contextId, json.toString());
                this.writeFile(p);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "", ex);
                throw new OceanaServicesException("failed to update context and schema for ContextId: " + ex.getMessage());
            }
        } else {
            throw new OceanaServicesException(CONTEXT_ID_DOES_NOT_EXIST);
        }
    }

    @Override
    public String getServiceMap(String contextId, String contextStoreIP, SCESession sceSession) throws OceanaServicesException {
        if (this.mySession.isTraceEnabled()) {
            ITraceInfo tr = this.mySession.getTraceOutput();
            tr.writeln(1, "Getting service map for : " + contextId);
        }
        Properties p = this.loadContext(this.mySession);
        this.checkExpired(contextId, p);
        if (p.containsKey(contextId)) {
            try {
                String context = p.getProperty(contextId);
                JSONObject json = new JSONObject(context);
                JSONObject schema = json.getJSONObject(SCHEMA);
                JSONObject sm = schema.getJSONObject(SERVICE_MAP);
                return "{\"ServiceMap\": " + sm.toString() + "}";
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "", ex);
                throw new OceanaServicesException("failed to get service map for ContextId: " + ex.getMessage());
            }
        }
        throw new OceanaServicesException(CONTEXT_ID_DOES_NOT_EXIST);
    }

    @Override
    public void updateJourney(String contextId, String data, String contextStoreIP, SCESession sceSession) throws OceanaServicesException {
        if (this.mySession.isTraceEnabled()) {
            ITraceInfo tr = this.mySession.getTraceOutput();
            tr.writeln(1, "Updating audit data for : " + contextId);
        }
        Properties p = this.loadContext(this.mySession);
        this.checkExpired(contextId, p);
        if (p.containsKey(contextId)) {
            try {
                String context = p.getProperty(contextId);
                JSONObject json = new JSONObject(context);
                this.fillContext(data, json);
                p.put(contextId, json.toString());
                this.writeFile(p);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "", ex);
                throw new OceanaServicesException("failed to update audit data for ContextId: " + ex.getMessage());
            }
        } else {
            throw new OceanaServicesException(CONTEXT_ID_DOES_NOT_EXIST);
        }
    }

    private void fillContext(String data, JSONObject json) {
        try {
            if (json.has(AUDIT)) {
                JSONArray audit = (JSONArray)json.get(AUDIT);
                JSONObject items = audit.getJSONObject(audit.length() - 1);
                int version = Integer.parseInt(items.getString(VERSION));
                ++version;
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("timeStamp", Long.toString(System.currentTimeMillis()));
                values.put("touchPoint", data);
                values.put(VERSION, Integer.toString(version));
                values.put("operationId", "UD_C_C");
                audit.put(values);
            } else {
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("timeStamp", Long.toString(System.currentTimeMillis()));
                values.put("touchPoint", data);
                values.put(VERSION, "1");
                values.put("operationId", "UD_C_C");
                JSONArray audit = new JSONArray();
                audit.put(values);
                json.put(AUDIT, (Object)audit);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "", e);
        }
    }

    @Override
    public String getCurrentWorkRequestCustomerJourney(String contextId, String contextStoreIP, SCESession sceSession) throws OceanaServicesException {
        if (this.mySession.isTraceEnabled()) {
            ITraceInfo tr = this.mySession.getTraceOutput();
            tr.writeln(1, "Getting audit data for : " + contextId);
        }
        Properties p = this.loadContext(this.mySession);
        this.checkExpired(contextId, p);
        if (p.containsKey(contextId)) {
            try {
                String context = p.getProperty(contextId);
                JSONObject json = new JSONObject(context);
                JSONArray auditData = json.getJSONArray(AUDIT);
                return "{\"audit\": " + auditData.toString() + "}";
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "", ex);
                throw new OceanaServicesException("failed to get audit data for ContextId: " + ex.getMessage());
            }
        }
        throw new OceanaServicesException(CONTEXT_ID_DOES_NOT_EXIST);
    }

    @Override
    public String findCustomerId(String email, String phone, String customerManagementIP, SCESession sceSession, String externalId, String accountType, String accountId, String handle, String platform) throws OceanaServicesException {
        if (this.mySession.isTraceEnabled()) {
            ITraceInfo tr = this.mySession.getTraceOutput();
            tr.writeln(1, "Getting customer id: ");
        }
        Properties p = this.loadContext(this.mySession);
        StringBuilder sbForAccount = new StringBuilder();
        sbForAccount.append(accountType);
        sbForAccount.append(accountId);
        String accountTypeAndId = sbForAccount.toString();
        StringBuilder sbForSocial = new StringBuilder();
        sbForSocial.append(handle);
        sbForSocial.append(platform);
        String handleAndPlatform = sbForSocial.toString();
        if (this.isFound(p, accountTypeAndId)) {
            return p.getProperty(accountTypeAndId);
        }
        if (this.isFound(p, externalId)) {
            return p.getProperty(externalId);
        }
        if (this.isFound(p, email)) {
            return p.getProperty(email);
        }
        if (this.isFound(p, phone)) {
            return p.getProperty(phone);
        }
        if (this.isFound(p, handleAndPlatform)) {
            return p.getProperty(handleAndPlatform);
        }
        return "{\"customerId\":\"cust123456\"}";
    }

    private boolean isFound(Properties p, String line) {
        return line != null && !"".equals(line.trim()) && p.containsKey(line);
    }

    @Override
    public String getCustomerJourneyByCustomerID(String customerId, String customerManagementIP, SCESession sceSession) throws OceanaServicesException {
        String result = null;
        if (this.mySession.isTraceEnabled()) {
            ITraceInfo tr = this.mySession.getTraceOutput();
            tr.writeln(1, "Getting customer journey for customerId: " + customerId);
        }
        Properties p = this.loadContext(this.mySession);
        this.checkExpired(customerId, p);
        if (p.containsKey(customerId)) {
            try {
                String customer = p.getProperty(customerId);
                result = this.isCustomerHistory(customer) ? null : customer;
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "", ex);
                throw new OceanaServicesException("failed to get customer journey for customerId: " + ex.getMessage());
            }
        }
        if (result == null) {
            result = "{ \"elementId2.0\": [ { \"summary\": \"summary\", \"elementId\": \"elementId2\", \"agentId\": \"agent\", \"routingId\": \"0\", \"source\": \"source\", \"type\": \"type\", \"agentNote\": \"note\", \"threadId\": \"threadId\", \"customerId\": \"customerId\", \"tenantId\": \"tenantId\", \"topic\": \"topic\", \"links\": [ { \"rel\": \"CRM\", \"href\": \"http://myWebsite.com\" }, { \"rel\": \"CRM\", \"href\": \"http://myOtherWebSite.com\" } ], \"modifiedDateTime\": \"1545329787417\", \"detail\": { \"key1\": \"value1\", \"key2\": \"value2\" }, \"status\": \"status\" } ], \"elementId.0\": [ { \"summary\": \"summary\", \"elementId\": \"elementId\", \"agentId\": \"agent\", \"routingId\": \"0\", \"source\": \"source\", \"type\": \"type\", \"agentNote\": \"note\", \"threadId\": \"threadId\", \"customerId\": \"customerId\", \"tenantId\": \"tenantId\", \"topic\": \"topic\", \"links\": [ { \"rel\": \"CRM\", \"href\": \"http://myWebSite.com\" }, { \"rel\": \"CRM\", \"href\": \"http://myOtherWebsite.com\" } ], \"modifiedDateTime\": \"1545329780557\", \"detail\": { \"key1\": \"value1\", \"key2\": \"value2\" }, \"status\": \"status\" } ] }";
        }
        return result;
    }

    @Override
    public String getCustomerHistory(String customerId, String workRequestId, String customerManagementIp, SCESession sceSession) throws OceanaServicesException {
        Properties p;
        if (this.mySession.isTraceEnabled()) {
            ITraceInfo tr = this.mySession.getTraceOutput();
            tr.writeln(1, "Getting customer History: ");
        }
        if (this.isFound(p = this.loadContext(this.mySession), customerId) && this.isCustomerHistory(p.getProperty(customerId))) {
            return p.getProperty(customerId);
        }
        if (this.isFound(p, workRequestId) && this.isCustomerHistory(p.getProperty(customerId))) {
            return p.getProperty(customerId);
        }
        return " {\"customerHistory\": [{\"id\": \"218\",\"href\": \"http://localhost/services/AgentControllerService/gila/api/customerhistory/218\",\"status\": \"CLOSED\",\"subject\": null,\"priority\": \"NORMAL\",\"type\": \"CHAT\",\"action\": null,\"createdDate\": \"1522155882000\",\"friendlyName\": null},{\"id\": \"215\",\"href\": \"http://localhost/services/AgentControllerService/gila/api/customerhistory/215\",\"status\": \"CLOSED\",\"subject\": null,\"priority\": \"NORMAL\",\"type\": \"CHAT\",\"action\": null,\"createdDate\": \"1522150583000\",\"friendlyName\": null}]}";
    }

    private boolean isCustomerHistory(String jsonStringLine) {
        JSONObject json = new JSONObject(jsonStringLine);
        return json.has(CUSTOMER_HISTORY_FIELD);
    }
}

