/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.pdc.oceanaservices.operations;

import com.avaya.sce.pdc.oceanaservices.IOceanaServices;
import com.avaya.sce.pdc.oceanaservices.OceanaServicesException;
import com.avaya.sce.pdc.oceanaservices.Utils;
import com.avaya.sce.pdc.oceanaservices.operations.OperationsHelper;
import com.avaya.sce.runtime.IPluggableExecutable;
import com.avaya.sce.runtimecommon.Debugging;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdateJourneyElement
extends Debugging
implements IPluggableExecutable {
    private static final Logger LOGGER = Logger.getLogger(UpdateJourneyElement.class.getName());
    private String contextStoreIpVar;
    private String contextStoreIpField;
    private boolean csIpIsConstant;
    private String contextIdVar;
    private String contextIdField;
    private String scVar;
    private String scField;
    private boolean srcIsConstant;
    private static final String OP = "Update Journey Element";

    public UpdateJourneyElement(String contextStoreIpVar, String contextStoreIpField, boolean csIpIsConstant, String contextIdVar, String contextIdField, String scVar, String scField, boolean srcIsConstant) {
        this.contextStoreIpVar = contextStoreIpVar;
        this.contextStoreIpField = contextStoreIpField;
        this.csIpIsConstant = csIpIsConstant;
        this.contextIdVar = contextIdVar;
        this.contextIdField = contextIdField;
        this.scVar = scVar;
        this.scField = scField;
        this.srcIsConstant = srcIsConstant;
    }

    public String getId() {
        return Utils.getOceanaServices();
    }

    public String getTraceMessage() {
        return "Update Journey Element ->" + this.scVar + ":" + this.scField;
    }

    public void execute(IRuntimeSession rtSession) {
        String resultMessage = "ERROR : ";
        SCESession mySession = (SCESession)rtSession;
        Exception ex = null;
        try {
            OperationsHelper.setFieldsToNull(this.scField);
            OperationsHelper.setFieldsToNull(this.contextStoreIpField);
            String contextId = mySession.getVariableField(new VariableName(this.contextIdVar, this.contextIdField)).getStringValue();
            OperationsHelper.traceContextId(mySession, contextId);
            String data = Utils.getValueFromParameter(this.scVar, this.scField, this.srcIsConstant, mySession);
            String contextStoreIp = Utils.getValueFromParameter(this.contextStoreIpVar, this.contextStoreIpField, this.csIpIsConstant, mySession);
            IOceanaServices oas = OperationsHelper.getOceanaServices(mySession, data, OP);
            oas.updateJourney(contextId, data, contextStoreIp, mySession);
            OperationsHelper.traceOperationSuccess(mySession, OP, contextId);
            return;
        }
        catch (OceanaServicesException e) {
            LOGGER.log(Level.WARNING, "", e);
            resultMessage = resultMessage + "Fail Update Journey Element : " + e;
            ex = e;
        }
        catch (Exception e) {
            resultMessage = resultMessage + "Could not Update Journey Element : " + e;
            ex = e;
        }
        mySession.throwRTException(resultMessage, ex);
    }
}

