/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ingensg.ce.wa.imrest.common.model;

import com.avaya.ingensg.ce.wa.imrest.common.model.Resource;
import com.avaya.ingensg.ce.wa.imrest.common.model.Service;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidProficiencyRange;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidRequestUpdate;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidService;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidSpecifiedResource;
import com.avaya.ingensg.ce.wa.imrest.common.model.vailidation.constraints.ValidURL;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@ValidRequestUpdate
@ValidSpecifiedResource
public class MatchUpdateRequest {
    @ApiModelProperty(value="URI used to send async responses back to. Only used in async requests", required=true, notes="Must be a valid URI", position=5)
    @NotNull(message="callbackUrl cannot be null")
    @ValidURL(message="Invalid callback URL")
    private String callbackUrl;
    @ApiModelProperty(value="Callback mechanism used to distinguish between types of callback destination", required=true, allowableValues="SimpleSDK, EventingFramework", position=6)
    @NotNull(message="The callback mechanism can not be null")
    @Pattern(regexp="SimpleSDK|EventingFramework", message="The provided callback mechanism must be one of SimpleSDK or EventingFramework")
    private String callbackMechanism;
    @ApiModelProperty(value="CorrelationId used to identify ACD instance and must be set when invoking Eventing Framework", required=false, position=7)
    private String correlationId;
    @ApiModelProperty(value="Ordered Map of Services we want to update", required=true, notes="min = 1, max = 6", position=4)
    @Size(min=0, max=6, message="A maximum of {max} services are permitted within the service map")
    @Valid
    @ValidService
    @ValidProficiencyRange
    private Map<Integer, Service> serviceMap;
    @ApiModelProperty(value="Ordered Map of Resources we want to match against", required=true, notes="min = 0, max = 3", position=3)
    @Size(min=0, max=3, message="A maximum of {max} resources are permitted within the resource map")
    @Valid
    private Map<Integer, Resource> resourceMap;

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getCallbackMechanism() {
        return this.callbackMechanism;
    }

    public void setCallbackMechanism(String callbackMechanism) {
        this.callbackMechanism = callbackMechanism;
    }

    public Map<Integer, Service> getServiceMap() {
        return this.serviceMap;
    }

    public void setServiceMap(Map<Integer, Service> serviceMap) {
        this.serviceMap = serviceMap;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public Map<Integer, Resource> getResourceMap() {
        return this.resourceMap;
    }

    public void setResourceMap(Map<Integer, Resource> resourceMap) {
        this.resourceMap = resourceMap;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

